/*
 * Decompiled with CFR 0.152.
 */
package io.skylite;

import io.skylite.SkyliteException;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public interface SkyliteExceptionProvider<E extends SkyliteException> {
    public static final int CUSTOM_ELASTICSEARCH_EXCEPTIONS_BASE_ID = 10000;

    public Class<E> getExceptionClass();

    public CheckedFunction<StreamInput, E, IOException> getConstructor();

    default public int getId() {
        return SkyliteExceptionProvider.hash(this.getExceptionClass().getCanonicalName());
    }

    public Version<?> getVersionAdded();

    default public int getLegacyId() {
        return -1;
    }

    public static int hash(String input) {
        byte[] utf8 = input.getBytes(StandardCharsets.UTF_8);
        byte[] hash = SkyliteExceptionProvider.sha256(utf8);
        return (hash[0] & 0xFF) << 24 | (hash[1] & 0xFF) << 16 | (hash[2] & 0xFF) << 8 | hash[3] & 0xFF;
    }

    private static byte[] sha256(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }
}

