/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core;

import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FeatureFlags {
    public static final String REMOTE_STORE_MIGRATION_EXPERIMENTAL = "lucenia.experimental.feature.remote_store.migration.enabled";
    public static final String SEGMENT_REPLICATION_EXPERIMENTAL = "lucenia.experimental.feature.segment_replication_experimental.enabled";
    public static final String SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY = "lucenia.experimental.feature.searchable_snapshot.extended_compatibility.enabled";
    public static final String EXTENSIONS = "lucenia.experimental.feature.extensions.enabled";
    public static final String IDENTITY = "lucenia.experimental.feature.identity.enabled";
    public static final String CONCURRENT_SEGMENT_SEARCH = "lucenia.experimental.feature.concurrent_segment_search.enabled";
    public static final String TELEMETRY = "lucenia.experimental.feature.telemetry.enabled";
    public static final String DATETIME_FORMATTER_CACHING = "lucenia.experimental.optimization.datetime_formatter_caching.enabled";
    private static Settings settings;
    public static final Setting<Boolean> SEGMENT_REPLICATION_EXPERIMENTAL_SETTING;
    public static final Setting<Boolean> REMOTE_STORE_MIGRATION_EXPERIMENTAL_SETTING;
    public static final Setting<Boolean> EXTENSIONS_SETTING;
    public static final Setting<Boolean> IDENTITY_SETTING;
    public static final Setting<Boolean> TELEMETRY_SETTING;
    public static final Setting<Boolean> CONCURRENT_SEGMENT_SEARCH_SETTING;
    public static final Setting<Boolean> DATETIME_FORMATTER_CACHING_SETTING;
    public static List<? extends Setting<?>> FEATURE_FLAG_SETTINGS;

    public static void initializeFeatureFlags(Settings luceniaSettings) {
        settings = luceniaSettings;
    }

    public static boolean isEnabled(String featureFlagName) {
        if ("true".equalsIgnoreCase(System.getProperty(featureFlagName))) {
            return true;
        }
        return settings != null && settings.getAsBoolean(featureFlagName, false) != false;
    }

    public static boolean isEnabled(Setting<Boolean> featureFlag) {
        if ("true".equalsIgnoreCase(System.getProperty(featureFlag.getKey()))) {
            return true;
        }
        if (settings != null) {
            return featureFlag.get(settings);
        }
        return featureFlag.getDefault(Settings.EMPTY);
    }

    static {
        SEGMENT_REPLICATION_EXPERIMENTAL_SETTING = Setting.boolSetting(SEGMENT_REPLICATION_EXPERIMENTAL, false, Setting.Property.NodeScope);
        REMOTE_STORE_MIGRATION_EXPERIMENTAL_SETTING = Setting.boolSetting(REMOTE_STORE_MIGRATION_EXPERIMENTAL, false, Setting.Property.NodeScope);
        EXTENSIONS_SETTING = Setting.boolSetting(EXTENSIONS, false, Setting.Property.NodeScope);
        IDENTITY_SETTING = Setting.boolSetting(IDENTITY, false, Setting.Property.NodeScope);
        TELEMETRY_SETTING = Setting.boolSetting(TELEMETRY, false, Setting.Property.NodeScope);
        CONCURRENT_SEGMENT_SEARCH_SETTING = Setting.boolSetting(CONCURRENT_SEGMENT_SEARCH, false, Setting.Property.NodeScope);
        DATETIME_FORMATTER_CACHING_SETTING = Setting.boolSetting(DATETIME_FORMATTER_CACHING, true, Setting.Property.NodeScope);
        FEATURE_FLAG_SETTINGS = Collections.unmodifiableList(Arrays.asList(SEGMENT_REPLICATION_EXPERIMENTAL_SETTING, EXTENSIONS_SETTING, IDENTITY_SETTING, CONCURRENT_SEGMENT_SEARCH_SETTING, TELEMETRY_SETTING, DATETIME_FORMATTER_CACHING_SETTING, REMOTE_STORE_MIGRATION_EXPERIMENTAL_SETTING));
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return FEATURE_FLAG_SETTINGS;
        }
    }
}

