/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.CheckedConsumer;
import io.skylite.common.CheckedFunction;
import io.skylite.common.CheckedRunnable;
import io.skylite.common.CheckedSupplier;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.NotifyOnceListener;
import io.skylite.common.annotation.PublicApi;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@PublicApi(since="1.0.0")
public final class ActionListenerHelper {
    private ActionListenerHelper() {
    }

    public static <Response> ActionListener<Response> wrap(final CheckedConsumer<Response, ? extends Exception> onResponse, final Consumer<Exception> onFailure) {
        return new ActionListener<Response>(){

            public void onResponse(Response response) {
                try {
                    onResponse.accept(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                onFailure.accept(e);
            }
        };
    }

    public static <T> ActionListener<T> delegateResponse(final ActionListener<T> delegate, final BiConsumer<ActionListener<T>, Exception> bc) {
        return new ActionListener<T>(){

            public void onResponse(T r) {
                delegate.onResponse(r);
            }

            public void onFailure(Exception e) {
                bc.accept(delegate, e);
            }
        };
    }

    public static <T, R> ActionListener<T> delegateFailure(final ActionListener<R> delegate, final BiConsumer<ActionListener<R>, T> bc) {
        return new ActionListener<T>(){

            public void onResponse(T r) {
                bc.accept(delegate, r);
            }

            public void onFailure(Exception e) {
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> ActionListener<Response> wrap(Runnable runnable) {
        return ActionListenerHelper.wrap(r -> runnable.run(), e -> runnable.run());
    }

    public static <T, Response> ActionListener<Response> map(final ActionListener<T> delegate, final CheckedFunction<Response, T, Exception> fn) {
        return new ActionListener<Response>(){

            public void onResponse(Response response) {
                Object mapped;
                try {
                    mapped = fn.apply(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                    return;
                }
                try {
                    delegate.onResponse(mapped);
                }
                catch (RuntimeException e) {
                    assert (false) : new AssertionError("map: listener.onResponse failed", e);
                    throw e;
                }
            }

            public void onFailure(Exception e) {
                try {
                    delegate.onFailure(e);
                }
                catch (RuntimeException ex) {
                    if (ex != e) {
                        ex.addSuppressed(e);
                    }
                    assert (false) : new AssertionError("map: listener.onFailure failed", ex);
                    throw ex;
                }
            }
        };
    }

    public static <Response> BiConsumer<Response, Exception> toBiConsumer(ActionListener<Response> listener) {
        return (response, throwable) -> {
            if (throwable == null) {
                listener.onResponse(response);
            } else {
                listener.onFailure(throwable);
            }
        };
    }

    public static <Response> void onResponse(Iterable<ActionListener<Response>> listeners, Response response) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onResponse(response);
            }
            catch (Exception ex) {
                try {
                    listener.onFailure(ex);
                }
                catch (Exception ex1) {
                    exceptionList.add(ex1);
                }
            }
        }
        SkyliteExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> void onFailure(Iterable<ActionListener<Response>> listeners, Exception failure) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onFailure(failure);
            }
            catch (Exception ex) {
                exceptionList.add(ex);
            }
        }
        SkyliteExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> ActionListener<Response> runAfter(final ActionListener<Response> delegate, final Runnable runAfter) {
        return new ActionListener<Response>(){

            public void onResponse(Response response) {
                try {
                    delegate.onResponse(response);
                }
                finally {
                    runAfter.run();
                }
            }

            public void onFailure(Exception e) {
                try {
                    delegate.onFailure(e);
                }
                finally {
                    runAfter.run();
                }
            }
        };
    }

    public static <Response> ActionListener<Response> runBefore(final ActionListener<Response> delegate, final CheckedRunnable<?> runBefore) {
        return new ActionListener<Response>(){

            public void onResponse(Response response) {
                try {
                    runBefore.run();
                }
                catch (Exception ex) {
                    delegate.onFailure(ex);
                    return;
                }
                delegate.onResponse(response);
            }

            public void onFailure(Exception e) {
                try {
                    runBefore.run();
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> ActionListener<Response> notifyOnce(final ActionListener<Response> delegate) {
        return new NotifyOnceListener<Response>(){

            protected void innerOnResponse(Response response) {
                delegate.onResponse(response);
            }

            protected void innerOnFailure(Exception e) {
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> void completeWith(ActionListener<Response> listener, CheckedSupplier<Response, ? extends Exception> supplier) {
        Object response;
        try {
            response = supplier.get();
        }
        catch (Exception e) {
            try {
                listener.onFailure(e);
            }
            catch (RuntimeException ex) {
                assert (false) : ex;
                throw ex;
            }
            return;
        }
        try {
            listener.onResponse(response);
        }
        catch (RuntimeException ex) {
            assert (false) : ex;
            throw ex;
        }
    }
}

