/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action;

import io.skylite.core.action.ActionRequest;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.index.Index;
import java.util.Collection;
import java.util.Optional;

public class RequestValidators<T extends ActionRequest> {
    private final Collection<RequestValidator<T>> validators;

    public RequestValidators(Collection<RequestValidator<T>> validators) {
        this.validators = validators;
    }

    public Optional<Exception> validateRequest(T request, ClusterState state, Index[] indices) {
        Exception exception = null;
        for (RequestValidator<T> validator : this.validators) {
            Optional<Exception> maybeException = validator.validateRequest(request, state, indices);
            if (!maybeException.isPresent()) continue;
            if (exception == null) {
                exception = maybeException.get();
                continue;
            }
            exception.addSuppressed(maybeException.get());
        }
        return Optional.ofNullable(exception);
    }

    public static interface RequestValidator<T extends ActionRequest> {
        public Optional<Exception> validateRequest(T var1, ClusterState var2, Index[] var3);
    }
}

