/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import java.io.IOException;
import java.util.Objects;

public class RoutingMissingException
extends SkyliteException {
    private final String type;
    private final String id;

    public RoutingMissingException(String index, String id) {
        this(index, "_doc", id);
    }

    public RoutingMissingException(String index, String type, String id) {
        super("routing is required for [" + index + "]/[" + id + "]", new Object[0]);
        Objects.requireNonNull(index, "index must not be null");
        Objects.requireNonNull(type, "type must not be null");
        Objects.requireNonNull(id, "id must not be null");
        this.setIndex(index);
        this.type = type;
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    public RoutingMissingException(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.id = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
    }

    public static class Registration
    implements SkyliteExceptionProvider<RoutingMissingException> {
        @Override
        public Class<RoutingMissingException> getExceptionClass() {
            return RoutingMissingException.class;
        }

        @Override
        public CheckedFunction<StreamInput, RoutingMissingException, IOException> getConstructor() {
            return RoutingMissingException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 79;
        }
    }
}

