/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class TimestampParsingException
extends SkyliteException {
    private final String timestamp;

    public TimestampParsingException(String timestamp) {
        super("failed to parse timestamp [" + timestamp + "]", new Object[0]);
        this.timestamp = timestamp;
    }

    public TimestampParsingException(String timestamp, Throwable cause) {
        super("failed to parse timestamp [" + timestamp + "]", cause, new Object[0]);
        this.timestamp = timestamp;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public TimestampParsingException(StreamInput in) throws IOException {
        super(in);
        this.timestamp = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.timestamp);
    }

    public static class Registration
    implements SkyliteExceptionProvider<TimestampParsingException> {
        @Override
        public Class<TimestampParsingException> getExceptionClass() {
            return TimestampParsingException.class;
        }

        @Override
        public CheckedFunction<StreamInput, TimestampParsingException, IOException> getConstructor() {
            return TimestampParsingException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 78;
        }
    }
}

