/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.common.Nullable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.rest.RestStatus;
import java.io.IOException;

public class UnavailableShardsException
extends SkyliteException {
    public UnavailableShardsException(@Nullable ShardId shardId, String message, Object ... args) {
        super(UnavailableShardsException.buildMessage(shardId, message), args);
    }

    public UnavailableShardsException(String index, int shardId, String message, Object ... args) {
        super(UnavailableShardsException.buildMessage(index, shardId, message), args);
    }

    private static String buildMessage(ShardId shardId, String message) {
        if (shardId == null) {
            return message;
        }
        return UnavailableShardsException.buildMessage(shardId.getIndexName(), shardId.id(), message);
    }

    private static String buildMessage(String index, int shardId, String message) {
        return "[" + index + "][" + shardId + "] " + message;
    }

    public UnavailableShardsException(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public RestStatus status() {
        return RestStatus.SERVICE_UNAVAILABLE;
    }

    public static class Registration
    implements SkyliteExceptionProvider<UnavailableShardsException> {
        @Override
        public Class<UnavailableShardsException> getExceptionClass() {
            return UnavailableShardsException.class;
        }

        @Override
        public CheckedFunction<StreamInput, UnavailableShardsException, IOException> getConstructor() {
            return UnavailableShardsException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 131;
        }
    }
}

