/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.decommission.awareness.get;

import io.skylite.SkyliteParseException;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.cluster.decommission.DecommissionStatus;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;

public class GetDecommissionStateResponse
extends ActionResponse
implements ToXContentObject {
    private String attributeValue;
    private DecommissionStatus status;

    public GetDecommissionStateResponse() {
        this(null, null);
    }

    public GetDecommissionStateResponse(String attributeValue, DecommissionStatus status) {
        this.attributeValue = attributeValue;
        this.status = status;
    }

    public GetDecommissionStateResponse(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.attributeValue = in.readString();
            this.status = DecommissionStatus.fromString(in.readString());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.attributeValue == null || this.status == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.attributeValue);
            out.writeString(this.status.status());
        }
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public DecommissionStatus getDecommissionStatus() {
        return this.status;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.attributeValue != null && this.status != null) {
            builder.field(this.attributeValue, (Object)this.status);
        }
        builder.endObject();
        return builder;
    }

    public static GetDecommissionStateResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        String attributeValue = null;
        DecommissionStatus status = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                attributeValue = parser.currentName();
                if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                    throw new SkyliteParseException("failed to parse status of decommissioning, expected string but found unknown type", new Object[0]);
                }
                status = DecommissionStatus.fromString(parser.text().toLowerCase(Locale.ROOT));
                continue;
            }
            throw new SkyliteParseException("failed to parse decommission state, expected [{}] but found [{}]", new Object[]{XContentParser.Token.FIELD_NAME, token});
        }
        return new GetDecommissionStateResponse(attributeValue, status);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetDecommissionStateResponse that = (GetDecommissionStateResponse)o;
        if (!Objects.equals(this.attributeValue, that.attributeValue)) {
            return false;
        }
        return Objects.equals((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributeValue, this.status});
    }
}

