/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.node.info;

import io.skylite.Build;
import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.Nullable;
import io.skylite.core.action.admin.cluster.node.info.PluginsAndModules;
import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.aggregations.AggregationInfo;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.http.HttpInfo;
import io.skylite.core.ingest.IngestInfo;
import io.skylite.core.monitor.JvmInfo;
import io.skylite.core.monitor.os.OsInfo;
import io.skylite.core.monitor.process.ProcessInfo;
import io.skylite.core.search.pipeline.SearchPipelineInfo;
import io.skylite.core.service.ReportingService;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPoolInfo;
import io.skylite.core.transport.TransportInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NodeInfo
extends BaseNodeResponse {
    private Version version;
    private Build build;
    @Nullable
    private Settings settings;
    private Map<Class<? extends ReportingService.Info>, ReportingService.Info> infoMap = new HashMap<Class<? extends ReportingService.Info>, ReportingService.Info>();
    @Nullable
    private ByteSizeValue totalIndexingBuffer;

    public NodeInfo(StreamInput in) throws IOException {
        super(in);
        this.version = in.readVersion();
        this.build = in.readBuild();
        this.totalIndexingBuffer = in.readBoolean() ? new ByteSizeValue(in.readLong()) : null;
        if (in.readBoolean()) {
            this.settings = Settings.readSettingsFromStream(in);
        }
        this.addInfoIfNonNull(OsInfo.class, in.readOptionalWriteable(OsInfo::new));
        this.addInfoIfNonNull(ProcessInfo.class, in.readOptionalWriteable(ProcessInfo::new));
        this.addInfoIfNonNull(JvmInfo.class, in.readOptionalWriteable(JvmInfo::new));
        this.addInfoIfNonNull(ThreadPoolInfo.class, in.readOptionalWriteable(ThreadPoolInfo::new));
        this.addInfoIfNonNull(TransportInfo.class, in.readOptionalWriteable(TransportInfo::new));
        this.addInfoIfNonNull(HttpInfo.class, in.readOptionalWriteable(HttpInfo::new));
        this.addInfoIfNonNull(PluginsAndModules.class, in.readOptionalWriteable(PluginsAndModules::new));
        this.addInfoIfNonNull(IngestInfo.class, in.readOptionalWriteable(IngestInfo::new));
        this.addInfoIfNonNull(AggregationInfo.class, in.readOptionalWriteable(AggregationInfo::new));
        if (in.getVersion().onOrAfter(OpenSearchVersion.V_2_7_0)) {
            this.addInfoIfNonNull(SearchPipelineInfo.class, in.readOptionalWriteable(SearchPipelineInfo::new));
        }
    }

    public NodeInfo(Version version, Build build, DiscoveryNode node, @Nullable Settings settings, @Nullable OsInfo os, @Nullable ProcessInfo process, @Nullable JvmInfo jvm, @Nullable ThreadPoolInfo threadPool, @Nullable TransportInfo transport, @Nullable HttpInfo http, @Nullable PluginsAndModules plugins, @Nullable IngestInfo ingest, @Nullable AggregationInfo aggsInfo, @Nullable ByteSizeValue totalIndexingBuffer, @Nullable SearchPipelineInfo searchPipelineInfo) {
        super(node);
        this.version = version;
        this.build = build;
        this.settings = settings;
        this.addInfoIfNonNull(OsInfo.class, os);
        this.addInfoIfNonNull(ProcessInfo.class, process);
        this.addInfoIfNonNull(JvmInfo.class, jvm);
        this.addInfoIfNonNull(ThreadPoolInfo.class, threadPool);
        this.addInfoIfNonNull(TransportInfo.class, transport);
        this.addInfoIfNonNull(HttpInfo.class, http);
        this.addInfoIfNonNull(PluginsAndModules.class, plugins);
        this.addInfoIfNonNull(IngestInfo.class, ingest);
        this.addInfoIfNonNull(AggregationInfo.class, aggsInfo);
        this.addInfoIfNonNull(SearchPipelineInfo.class, searchPipelineInfo);
        this.totalIndexingBuffer = totalIndexingBuffer;
    }

    @Nullable
    public String getHostname() {
        return this.getNode().getHostName();
    }

    public Version getVersion() {
        return this.version;
    }

    public Build getBuild() {
        return this.build;
    }

    @Nullable
    public Settings getSettings() {
        return this.settings;
    }

    public <T extends ReportingService.Info> T getInfo(Class<T> clazz) {
        return (T)((ReportingService.Info)clazz.cast(this.infoMap.get(clazz)));
    }

    @Nullable
    public ByteSizeValue getTotalIndexingBuffer() {
        return this.totalIndexingBuffer;
    }

    private <T extends ReportingService.Info> void addInfoIfNonNull(Class<T> clazz, T info) {
        if (info != null) {
            this.infoMap.put(clazz, info);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.version.id);
        out.writeBuild(this.build);
        if (this.totalIndexingBuffer == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.totalIndexingBuffer.getBytes());
        }
        if (this.settings == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Settings.writeSettingsToStream(this.settings, out);
        }
        out.writeOptionalWriteable(this.getInfo(OsInfo.class));
        out.writeOptionalWriteable(this.getInfo(ProcessInfo.class));
        out.writeOptionalWriteable(this.getInfo(JvmInfo.class));
        out.writeOptionalWriteable(this.getInfo(ThreadPoolInfo.class));
        out.writeOptionalWriteable(this.getInfo(TransportInfo.class));
        out.writeOptionalWriteable(this.getInfo(HttpInfo.class));
        out.writeOptionalWriteable(this.getInfo(PluginsAndModules.class));
        out.writeOptionalWriteable(this.getInfo(IngestInfo.class));
        out.writeOptionalWriteable(this.getInfo(AggregationInfo.class));
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_7_0)) {
            out.writeOptionalWriteable(this.getInfo(SearchPipelineInfo.class));
        }
    }

    public static Builder builder(Version version, Build build, DiscoveryNode node) {
        return new Builder(version, build, node);
    }

    public static class Builder {
        private final Version version;
        private final Build build;
        private final DiscoveryNode node;
        private Settings settings;
        private OsInfo os;
        private ProcessInfo process;
        private JvmInfo jvm;
        private ThreadPoolInfo threadPool;
        private TransportInfo transport;
        private HttpInfo http;
        private PluginsAndModules plugins;
        private IngestInfo ingest;
        private AggregationInfo aggsInfo;
        private ByteSizeValue totalIndexingBuffer;
        private SearchPipelineInfo searchPipelineInfo;

        private Builder(Version version, Build build, DiscoveryNode node) {
            this.version = version;
            this.build = build;
            this.node = node;
        }

        public Builder setSettings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder setOs(OsInfo os) {
            this.os = os;
            return this;
        }

        public Builder setProcess(ProcessInfo process) {
            this.process = process;
            return this;
        }

        public Builder setJvm(JvmInfo jvm) {
            this.jvm = jvm;
            return this;
        }

        public Builder setThreadPool(ThreadPoolInfo threadPool) {
            this.threadPool = threadPool;
            return this;
        }

        public Builder setTransport(TransportInfo transport) {
            this.transport = transport;
            return this;
        }

        public Builder setHttp(HttpInfo http) {
            this.http = http;
            return this;
        }

        public Builder setPlugins(PluginsAndModules plugins) {
            this.plugins = plugins;
            return this;
        }

        public Builder setIngest(IngestInfo ingest) {
            this.ingest = ingest;
            return this;
        }

        public Builder setAggsInfo(AggregationInfo aggsInfo) {
            this.aggsInfo = aggsInfo;
            return this;
        }

        public Builder setTotalIndexingBuffer(ByteSizeValue totalIndexingBuffer) {
            this.totalIndexingBuffer = totalIndexingBuffer;
            return this;
        }

        public Builder setSearchPipelineInfo(SearchPipelineInfo searchPipelineInfo) {
            this.searchPipelineInfo = searchPipelineInfo;
            return this;
        }

        public NodeInfo build() {
            return new NodeInfo(this.version, this.build, this.node, this.settings, this.os, this.process, this.jvm, this.threadPool, this.transport, this.http, this.plugins, this.ingest, this.aggsInfo, this.totalIndexingBuffer, this.searchPipelineInfo);
        }
    }
}

