/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.node.stats;

import io.skylite.OpenSearchVersion;
import io.skylite.common.Nullable;
import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.NodeRole;
import io.skylite.core.cluster.routing.WeightedRoutingStats;
import io.skylite.core.cluster.service.ClusterManagerThrottlingStats;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.discovery.DiscoveryStats;
import io.skylite.core.http.HttpStats;
import io.skylite.core.index.SegmentReplicationRejectionStats;
import io.skylite.core.index.pressure.IndexingPressureStats;
import io.skylite.core.index.pressure.ShardIndexingPressureStats;
import io.skylite.core.index.remote.filecache.FileCacheStats;
import io.skylite.core.indices.NodeIndicesStats;
import io.skylite.core.indices.breaker.AllCircuitBreakerStats;
import io.skylite.core.ingest.IngestStats;
import io.skylite.core.monitor.FsInfo;
import io.skylite.core.monitor.jvm.JvmStats;
import io.skylite.core.monitor.os.OsStats;
import io.skylite.core.monitor.process.ProcessStats;
import io.skylite.core.node.AdaptiveSelectionStats;
import io.skylite.core.node.NodesResourceUsageStats;
import io.skylite.core.repositories.RepositoriesStats;
import io.skylite.core.script.ScriptCacheStats;
import io.skylite.core.script.ScriptStats;
import io.skylite.core.search.backpressure.stats.SearchBackpressureStats;
import io.skylite.core.search.pipeline.SearchPipelineStats;
import io.skylite.core.tasks.TaskCancellationStats;
import io.skylite.core.threadpool.ThreadPoolStats;
import io.skylite.core.transport.TransportStats;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Map;

public class NodeStats
extends BaseNodeResponse
implements ToXContentFragment {
    private long timestamp;
    @Nullable
    private NodeIndicesStats indices;
    @Nullable
    private OsStats os;
    @Nullable
    private ProcessStats process;
    @Nullable
    private JvmStats jvm;
    @Nullable
    private ThreadPoolStats threadPool;
    @Nullable
    private FsInfo fs;
    @Nullable
    private TransportStats transport;
    @Nullable
    private HttpStats http;
    @Nullable
    private AllCircuitBreakerStats breaker;
    @Nullable
    private ScriptStats scriptStats;
    @Nullable
    private ScriptCacheStats scriptCacheStats;
    @Nullable
    private DiscoveryStats discoveryStats;
    @Nullable
    private IngestStats ingestStats;
    @Nullable
    private AdaptiveSelectionStats adaptiveSelectionStats;
    @Nullable
    private IndexingPressureStats indexingPressureStats;
    @Nullable
    private ShardIndexingPressureStats shardIndexingPressureStats;
    @Nullable
    private SearchBackpressureStats searchBackpressureStats;
    @Nullable
    private SegmentReplicationRejectionStats segmentReplicationRejectionStats;
    @Nullable
    private ClusterManagerThrottlingStats clusterManagerThrottlingStats;
    @Nullable
    private WeightedRoutingStats weightedRoutingStats;
    @Nullable
    private FileCacheStats fileCacheStats;
    @Nullable
    private TaskCancellationStats taskCancellationStats;
    @Nullable
    private SearchPipelineStats searchPipelineStats;
    @Nullable
    private NodesResourceUsageStats resourceUsageStats;
    @Nullable
    private RepositoriesStats repositoriesStats;

    public NodeStats(StreamInput in) throws IOException {
        super(in);
        this.timestamp = in.readVLong();
        if (in.readBoolean()) {
            this.indices = new NodeIndicesStats(in);
        }
        this.os = in.readOptionalWriteable(OsStats::new);
        this.process = in.readOptionalWriteable(ProcessStats::new);
        this.jvm = in.readOptionalWriteable(JvmStats::new);
        this.threadPool = in.readOptionalWriteable(ThreadPoolStats::new);
        this.fs = in.readOptionalWriteable(FsInfo::new);
        this.transport = in.readOptionalWriteable(TransportStats::new);
        this.http = in.readOptionalWriteable(HttpStats::new);
        this.breaker = in.readOptionalWriteable(AllCircuitBreakerStats::new);
        this.scriptStats = in.readOptionalWriteable(ScriptStats::new);
        this.discoveryStats = in.readOptionalWriteable(DiscoveryStats::new);
        this.ingestStats = in.readOptionalWriteable(IngestStats::new);
        this.adaptiveSelectionStats = in.readOptionalWriteable(AdaptiveSelectionStats::new);
        this.scriptCacheStats = null;
        if (this.scriptStats != null) {
            this.scriptCacheStats = this.scriptStats.toScriptCacheStats();
        }
        this.indexingPressureStats = in.readOptionalWriteable(IndexingPressureStats::new);
        this.shardIndexingPressureStats = in.readOptionalWriteable(ShardIndexingPressureStats::new);
        this.searchBackpressureStats = in.getVersion().onOrAfter(OpenSearchVersion.V_2_4_0) ? in.readOptionalWriteable(SearchBackpressureStats::new) : null;
        this.clusterManagerThrottlingStats = in.getVersion().onOrAfter(OpenSearchVersion.V_2_6_0) ? in.readOptionalWriteable(ClusterManagerThrottlingStats::new) : null;
        this.weightedRoutingStats = in.getVersion().onOrAfter(OpenSearchVersion.V_2_6_0) ? in.readOptionalWriteable(WeightedRoutingStats::new) : null;
        this.fileCacheStats = in.getVersion().onOrAfter(OpenSearchVersion.V_2_7_0) ? in.readOptionalWriteable(FileCacheStats::new) : null;
        this.taskCancellationStats = in.getVersion().onOrAfter(OpenSearchVersion.V_2_9_0) ? in.readOptionalWriteable(TaskCancellationStats::new) : null;
        this.searchPipelineStats = in.getVersion().onOrAfter(OpenSearchVersion.V_2_9_0) ? in.readOptionalWriteable(SearchPipelineStats::new) : null;
        this.resourceUsageStats = in.getVersion().onOrAfter(OpenSearchVersion.V_2_12_0) ? in.readOptionalWriteable(NodesResourceUsageStats::new) : null;
        this.segmentReplicationRejectionStats = in.getVersion().onOrAfter(OpenSearchVersion.V_2_12_0) ? in.readOptionalWriteable(SegmentReplicationRejectionStats::new) : null;
        this.repositoriesStats = in.getVersion().onOrAfter(OpenSearchVersion.V_2_12_0) ? in.readOptionalWriteable(RepositoriesStats::new) : null;
    }

    public NodeStats(DiscoveryNode node, long timestamp, @Nullable NodeIndicesStats indices, @Nullable OsStats os, @Nullable ProcessStats process, @Nullable JvmStats jvm, @Nullable ThreadPoolStats threadPool, @Nullable FsInfo fs, @Nullable TransportStats transport, @Nullable HttpStats http, @Nullable AllCircuitBreakerStats breaker, @Nullable ScriptStats scriptStats, @Nullable DiscoveryStats discoveryStats, @Nullable IngestStats ingestStats, @Nullable AdaptiveSelectionStats adaptiveSelectionStats, @Nullable NodesResourceUsageStats resourceUsageStats, @Nullable ScriptCacheStats scriptCacheStats, @Nullable IndexingPressureStats indexingPressureStats, @Nullable ShardIndexingPressureStats shardIndexingPressureStats, @Nullable SearchBackpressureStats searchBackpressureStats, @Nullable ClusterManagerThrottlingStats clusterManagerThrottlingStats, @Nullable WeightedRoutingStats weightedRoutingStats, @Nullable FileCacheStats fileCacheStats, @Nullable TaskCancellationStats taskCancellationStats, @Nullable SearchPipelineStats searchPipelineStats, @Nullable SegmentReplicationRejectionStats segmentReplicationRejectionStats, @Nullable RepositoriesStats repositoriesStats) {
        super(node);
        this.timestamp = timestamp;
        this.indices = indices;
        this.os = os;
        this.process = process;
        this.jvm = jvm;
        this.threadPool = threadPool;
        this.fs = fs;
        this.transport = transport;
        this.http = http;
        this.breaker = breaker;
        this.scriptStats = scriptStats;
        this.discoveryStats = discoveryStats;
        this.ingestStats = ingestStats;
        this.adaptiveSelectionStats = adaptiveSelectionStats;
        this.resourceUsageStats = resourceUsageStats;
        this.scriptCacheStats = scriptCacheStats;
        this.indexingPressureStats = indexingPressureStats;
        this.shardIndexingPressureStats = shardIndexingPressureStats;
        this.searchBackpressureStats = searchBackpressureStats;
        this.clusterManagerThrottlingStats = clusterManagerThrottlingStats;
        this.weightedRoutingStats = weightedRoutingStats;
        this.fileCacheStats = fileCacheStats;
        this.taskCancellationStats = taskCancellationStats;
        this.searchPipelineStats = searchPipelineStats;
        this.segmentReplicationRejectionStats = segmentReplicationRejectionStats;
        this.repositoriesStats = repositoriesStats;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public String getHostname() {
        return this.getNode().getHostName();
    }

    @Nullable
    public NodeIndicesStats getIndices() {
        return this.indices;
    }

    @Nullable
    public OsStats getOs() {
        return this.os;
    }

    @Nullable
    public ProcessStats getProcess() {
        return this.process;
    }

    @Nullable
    public JvmStats getJvm() {
        return this.jvm;
    }

    @Nullable
    public ThreadPoolStats getThreadPool() {
        return this.threadPool;
    }

    @Nullable
    public FsInfo getFs() {
        return this.fs;
    }

    @Nullable
    public TransportStats getTransport() {
        return this.transport;
    }

    @Nullable
    public HttpStats getHttp() {
        return this.http;
    }

    @Nullable
    public AllCircuitBreakerStats getBreaker() {
        return this.breaker;
    }

    @Nullable
    public ScriptStats getScriptStats() {
        return this.scriptStats;
    }

    @Nullable
    public DiscoveryStats getDiscoveryStats() {
        return this.discoveryStats;
    }

    @Nullable
    public IngestStats getIngestStats() {
        return this.ingestStats;
    }

    @Nullable
    public AdaptiveSelectionStats getAdaptiveSelectionStats() {
        return this.adaptiveSelectionStats;
    }

    @Nullable
    public NodesResourceUsageStats getResourceUsageStats() {
        return this.resourceUsageStats;
    }

    @Nullable
    public ScriptCacheStats getScriptCacheStats() {
        return this.scriptCacheStats;
    }

    @Nullable
    public IndexingPressureStats getIndexingPressureStats() {
        return this.indexingPressureStats;
    }

    @Nullable
    public ShardIndexingPressureStats getShardIndexingPressureStats() {
        return this.shardIndexingPressureStats;
    }

    @Nullable
    public SearchBackpressureStats getSearchBackpressureStats() {
        return this.searchBackpressureStats;
    }

    @Nullable
    public ClusterManagerThrottlingStats getClusterManagerThrottlingStats() {
        return this.clusterManagerThrottlingStats;
    }

    public WeightedRoutingStats getWeightedRoutingStats() {
        return this.weightedRoutingStats;
    }

    public FileCacheStats getFileCacheStats() {
        return this.fileCacheStats;
    }

    @Nullable
    public TaskCancellationStats getTaskCancellationStats() {
        return this.taskCancellationStats;
    }

    @Nullable
    public SearchPipelineStats getSearchPipelineStats() {
        return this.searchPipelineStats;
    }

    @Nullable
    public SegmentReplicationRejectionStats getSegmentReplicationRejectionStats() {
        return this.segmentReplicationRejectionStats;
    }

    @Nullable
    public RepositoriesStats getRepositoriesStats() {
        return this.repositoriesStats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timestamp);
        if (this.indices == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.indices.writeTo(out);
        }
        out.writeOptionalWriteable(this.os);
        out.writeOptionalWriteable(this.process);
        out.writeOptionalWriteable(this.jvm);
        out.writeOptionalWriteable(this.threadPool);
        out.writeOptionalWriteable(this.fs);
        out.writeOptionalWriteable(this.transport);
        out.writeOptionalWriteable(this.http);
        out.writeOptionalWriteable(this.breaker);
        out.writeOptionalWriteable(this.scriptStats);
        out.writeOptionalWriteable(this.discoveryStats);
        out.writeOptionalWriteable(this.ingestStats);
        out.writeOptionalWriteable(this.adaptiveSelectionStats);
        out.writeOptionalWriteable(this.indexingPressureStats);
        out.writeOptionalWriteable(this.shardIndexingPressureStats);
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_4_0)) {
            out.writeOptionalWriteable(this.searchBackpressureStats);
        }
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_6_0)) {
            out.writeOptionalWriteable(this.clusterManagerThrottlingStats);
        }
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_6_0)) {
            out.writeOptionalWriteable(this.weightedRoutingStats);
        }
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_7_0)) {
            out.writeOptionalWriteable(this.fileCacheStats);
        }
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_9_0)) {
            out.writeOptionalWriteable(this.taskCancellationStats);
        }
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_9_0)) {
            out.writeOptionalWriteable(this.searchPipelineStats);
        }
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_12_0)) {
            out.writeOptionalWriteable(this.resourceUsageStats);
        }
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_12_0)) {
            out.writeOptionalWriteable(this.segmentReplicationRejectionStats);
        }
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_12_0)) {
            out.writeOptionalWriteable(this.repositoriesStats);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("name", this.getNode().getName());
        builder.field("transport_address", this.getNode().getAddress().toString());
        builder.field("host", this.getNode().getHostName());
        builder.field("ip", this.getNode().getAddress());
        builder.startArray("roles");
        for (NodeRole nodeRole : this.getNode().getRoles()) {
            builder.value(nodeRole.roleName());
        }
        builder.endArray();
        if (!this.getNode().getAttributes().isEmpty()) {
            builder.startObject("attributes");
            for (Map.Entry entry : this.getNode().getAttributes().entrySet()) {
                builder.field((String)entry.getKey(), (String)entry.getValue());
            }
            builder.endObject();
        }
        if (this.getIndices() != null) {
            this.getIndices().toXContent(builder, params);
        }
        if (this.getOs() != null) {
            this.getOs().toXContent(builder, params);
        }
        if (this.getProcess() != null) {
            this.getProcess().toXContent(builder, params);
        }
        if (this.getJvm() != null) {
            this.getJvm().toXContent(builder, params);
        }
        if (this.getThreadPool() != null) {
            this.getThreadPool().toXContent(builder, params);
        }
        if (this.getFs() != null) {
            this.getFs().toXContent(builder, params);
        }
        if (this.getTransport() != null) {
            this.getTransport().toXContent(builder, params);
        }
        if (this.getHttp() != null) {
            this.getHttp().toXContent(builder, params);
        }
        if (this.getBreaker() != null) {
            this.getBreaker().toXContent(builder, params);
        }
        if (this.getScriptStats() != null) {
            this.getScriptStats().toXContent(builder, params);
        }
        if (this.getDiscoveryStats() != null) {
            this.getDiscoveryStats().toXContent(builder, params);
        }
        if (this.getIngestStats() != null) {
            this.getIngestStats().toXContent(builder, params);
        }
        if (this.getAdaptiveSelectionStats() != null) {
            this.getAdaptiveSelectionStats().toXContent(builder, params);
        }
        if (this.getScriptCacheStats() != null) {
            this.getScriptCacheStats().toXContent(builder, params);
        }
        if (this.getIndexingPressureStats() != null) {
            this.getIndexingPressureStats().toXContent(builder, params);
        }
        if (this.getShardIndexingPressureStats() != null) {
            this.getShardIndexingPressureStats().toXContent(builder, params);
        }
        if (this.getSearchBackpressureStats() != null) {
            this.getSearchBackpressureStats().toXContent(builder, params);
        }
        if (this.getClusterManagerThrottlingStats() != null) {
            this.getClusterManagerThrottlingStats().toXContent(builder, params);
        }
        if (this.getWeightedRoutingStats() != null) {
            this.getWeightedRoutingStats().toXContent(builder, params);
        }
        if (this.getFileCacheStats() != null) {
            this.getFileCacheStats().toXContent(builder, params);
        }
        if (this.getTaskCancellationStats() != null) {
            this.getTaskCancellationStats().toXContent(builder, params);
        }
        if (this.getSearchPipelineStats() != null) {
            this.getSearchPipelineStats().toXContent(builder, params);
        }
        if (this.getResourceUsageStats() != null) {
            this.getResourceUsageStats().toXContent(builder, params);
        }
        if (this.getSegmentReplicationRejectionStats() != null) {
            this.getSegmentReplicationRejectionStats().toXContent(builder, params);
        }
        if (this.getRepositoriesStats() != null) {
            this.getRepositoriesStats().toXContent(builder, params);
        }
        return builder;
    }
}

