/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.remotestore.stats;

import io.skylite.core.action.admin.cluster.remotestore.stats.RemoteStoreStats;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.broadcast.BroadcastResponse;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoteStoreStatsResponse
extends BroadcastResponse {
    private final RemoteStoreStats[] remoteStoreStats;

    public RemoteStoreStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.remoteStoreStats = in.readArray(RemoteStoreStats::new, RemoteStoreStats[]::new);
    }

    public RemoteStoreStatsResponse(RemoteStoreStats[] remoteStoreStats, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.remoteStoreStats = remoteStoreStats;
    }

    public RemoteStoreStats[] getRemoteStoreStats() {
        return this.remoteStoreStats;
    }

    public Map<String, Map<Integer, List<RemoteStoreStats>>> groupByIndexAndShards() {
        HashMap<String, Map<Integer, List<RemoteStoreStats>>> indexWiseStats = new HashMap<String, Map<Integer, List<RemoteStoreStats>>>();
        for (RemoteStoreStats shardStat : this.remoteStoreStats) {
            indexWiseStats.computeIfAbsent(shardStat.getShardRouting().getIndexName(), k -> new HashMap()).computeIfAbsent(shardStat.getShardRouting().getId(), k -> new ArrayList()).add(shardStat);
        }
        return indexWiseStats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray(this.remoteStoreStats);
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Map<String, Map<Integer, List<RemoteStoreStats>>> indexWiseStats = this.groupByIndexAndShards();
        builder.startObject("indices");
        for (String indexName : indexWiseStats.keySet()) {
            builder.startObject(indexName);
            builder.startObject("shards");
            for (int shardId : indexWiseStats.get(indexName).keySet()) {
                builder.startArray(Integer.toString(shardId));
                for (RemoteStoreStats shardStat : indexWiseStats.get(indexName).get(shardId)) {
                    shardStat.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, false);
    }

    static final class Fields {
        static final String SHARDS = "shards";
        static final String INDICES = "indices";

        Fields() {
        }
    }
}

