/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.settings;

import io.skylite.core.ParseField;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;

public class ClusterUpdateSettingsResponse
extends AcknowledgedResponse {
    private static final ParseField PERSISTENT = new ParseField("persistent", new String[0]);
    private static final ParseField TRANSIENT = new ParseField("transient", new String[0]);
    private static final ConstructingObjectParser<ClusterUpdateSettingsResponse, Void> PARSER = new ConstructingObjectParser("cluster_update_settings_response", true, args -> new ClusterUpdateSettingsResponse((Boolean)args[0], (Settings)args[1], (Settings)args[2]));
    final Settings transientSettings;
    final Settings persistentSettings;

    public ClusterUpdateSettingsResponse(StreamInput in) throws IOException {
        super(in);
        this.transientSettings = Settings.readSettingsFromStream(in);
        this.persistentSettings = Settings.readSettingsFromStream(in);
    }

    public ClusterUpdateSettingsResponse(boolean acknowledged, Settings transientSettings, Settings persistentSettings) {
        super(acknowledged);
        this.persistentSettings = persistentSettings;
        this.transientSettings = transientSettings;
    }

    public Settings getTransientSettings() {
        return this.transientSettings;
    }

    public Settings getPersistentSettings() {
        return this.persistentSettings;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Settings.writeSettingsToStream(this.transientSettings, out);
        Settings.writeSettingsToStream(this.persistentSettings, out);
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(PERSISTENT.getPreferredName());
        this.persistentSettings.toXContent(builder, params);
        builder.endObject();
        builder.startObject(TRANSIENT.getPreferredName());
        this.transientSettings.toXContent(builder, params);
        builder.endObject();
    }

    public static ClusterUpdateSettingsResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            ClusterUpdateSettingsResponse that = (ClusterUpdateSettingsResponse)o;
            return Objects.equals(this.transientSettings, that.transientSettings) && Objects.equals(this.persistentSettings, that.persistentSettings);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.transientSettings, this.persistentSettings);
    }

    static {
        ClusterUpdateSettingsResponse.declareAcknowledgedField(PARSER);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Settings.fromXContent(p), TRANSIENT);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Settings.fromXContent(p), PERSISTENT);
    }
}

