/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.shards;

import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;

public class ClusterSearchShardsGroup
implements Writeable,
ToXContentObject {
    private final ShardId shardId;
    private final ShardRouting[] shards;

    public ClusterSearchShardsGroup(ShardId shardId, ShardRouting[] shards) {
        this.shardId = shardId;
        this.shards = shards;
    }

    ClusterSearchShardsGroup(StreamInput in) throws IOException {
        this.shardId = new ShardId(in);
        this.shards = in.readArray(i -> new ShardRouting(this.shardId, i), ShardRouting[]::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeArray((o, s) -> s.writeToThin(o), this.shards);
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public ShardRouting[] getShards() {
        return this.shards;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray();
        for (ShardRouting shard : this.getShards()) {
            shard.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

