/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.shards.routing.weighted.delete;

import io.skylite.SkyliteGenerationException;
import io.skylite.SkyliteParseException;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterDeleteWeightedRoutingRequest
extends ClusterManagerNodeRequest<ClusterDeleteWeightedRoutingRequest> {
    private static final Logger logger = LogManager.getLogger(ClusterDeleteWeightedRoutingRequest.class);
    private long version;
    private String awarenessAttribute;

    public void setVersion(long version) {
        this.version = version;
    }

    public ClusterDeleteWeightedRoutingRequest() {
        this.version = -2L;
    }

    public ClusterDeleteWeightedRoutingRequest(StreamInput in) throws IOException {
        super(in);
        this.version = in.readLong();
        if (in.available() != 0) {
            this.awarenessAttribute = in.readString();
        }
    }

    public long getVersion() {
        return this.version;
    }

    public String getAwarenessAttribute() {
        return this.awarenessAttribute;
    }

    public void setAwarenessAttribute(String awarenessAttribute) {
        this.awarenessAttribute = awarenessAttribute;
    }

    public ClusterDeleteWeightedRoutingRequest(String awarenessAttribute) {
        this.awarenessAttribute = awarenessAttribute;
        this.version = -2L;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public ClusterDeleteWeightedRoutingRequest source(Map<String, String> source) {
        try {
            if (source.isEmpty()) {
                throw new SkyliteParseException("Empty request body", new Object[0]);
            }
            XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder();
            builder.map(source);
            this.setRequestBody(BytesReference.bytes(builder), builder.contentType());
        }
        catch (IOException e) {
            throw new SkyliteGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
        return this;
    }

    private void setRequestBody(BytesReference source, MediaType contentType) {
        try (XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, source, contentType);){
            XContentParser.Token token;
            String versionAttr = null;
            parser.nextToken();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    if (fieldName != null && fieldName.equals("_version")) {
                        versionAttr = parser.currentName();
                        continue;
                    }
                    throw new SkyliteParseException("failed to parse delete weighted routing request body [{}], unknown type", fieldName);
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if (versionAttr == null || !versionAttr.equals("_version")) continue;
                    this.version = Long.parseLong(parser.text());
                    continue;
                }
                throw new SkyliteParseException("failed to parse delete weighted routing request body", new Object[0]);
            }
        }
        catch (IOException e) {
            logger.error("error while parsing delete request for weighted routing request object", (Throwable)e);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.version);
        if (this.awarenessAttribute != null) {
            out.writeString(this.awarenessAttribute);
        }
    }

    public String toString() {
        return "ClusterDeleteWeightedRoutingRequest{version= " + this.version + "awarenessAttribute=" + this.awarenessAttribute + "}";
    }
}

