/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.state;

import io.skylite.core.action.ActionResponse;
import io.skylite.core.cluster.ClusterName;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.Objects;

public class ClusterStateResponse
extends ActionResponse {
    private ClusterName clusterName;
    private ClusterState clusterState;
    private boolean waitForTimedOut = false;

    public ClusterStateResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterName = new ClusterName(in);
        this.clusterState = in.readOptionalWriteable(innerIn -> ClusterState.readFrom(innerIn, null));
        this.waitForTimedOut = in.readBoolean();
    }

    public ClusterStateResponse(ClusterName clusterName, ClusterState clusterState, boolean waitForTimedOut) {
        this.clusterName = clusterName;
        this.clusterState = clusterState;
        this.waitForTimedOut = waitForTimedOut;
    }

    public ClusterState getState() {
        return this.clusterState;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public boolean isWaitForTimedOut() {
        return this.waitForTimedOut;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        out.writeOptionalWriteable(this.clusterState);
        out.writeBoolean(this.waitForTimedOut);
    }

    public String toString() {
        return "ClusterStateResponse{clusterState=" + String.valueOf(this.clusterState) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateResponse response = (ClusterStateResponse)o;
        return this.waitForTimedOut == response.waitForTimedOut && Objects.equals(this.clusterName, response.clusterName) && Objects.equals(ClusterStateResponse.getVersion(this.clusterState), ClusterStateResponse.getVersion(response.clusterState)) && Objects.equals(ClusterStateResponse.getClusterManagerNodeId(this.clusterState), ClusterStateResponse.getClusterManagerNodeId(response.clusterState));
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, ClusterStateResponse.getVersion(this.clusterState), ClusterStateResponse.getClusterManagerNodeId(this.clusterState), this.waitForTimedOut);
    }

    private static String getClusterManagerNodeId(ClusterState clusterState) {
        if (clusterState == null) {
            return null;
        }
        DiscoveryNodes nodes = clusterState.getNodes();
        if (nodes != null) {
            return nodes.getClusterManagerNodeId();
        }
        return null;
    }

    private static Long getVersion(ClusterState clusterState) {
        if (clusterState != null) {
            return clusterState.getVersion();
        }
        return null;
    }
}

