/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.storedscripts;

import io.skylite.OpenSearchVersion;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.clustermanager.AcknowledgedRequest;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.script.StoredScriptSource;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MetadataStateFormat;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.util.Objects;

public class PutStoredScriptRequest
extends AcknowledgedRequest<PutStoredScriptRequest>
implements ToXContentFragment {
    private String id;
    private String context;
    private BytesReference content;
    private MediaType mediaType;
    private StoredScriptSource source;

    public PutStoredScriptRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readOptionalString();
        this.content = in.readBytesReference();
        this.mediaType = in.getVersion().onOrAfter(OpenSearchVersion.V_2_10_0) ? in.readMediaType() : MetadataStateFormat.XCONTENT_TYPE_BWC_PROVIDER.getXContentTypeByOrdinal(in.readVInt());
        this.context = in.readOptionalString();
        this.source = new StoredScriptSource(in);
    }

    public PutStoredScriptRequest() {
    }

    public PutStoredScriptRequest(String id, String context, BytesReference content, MediaType mediaType, StoredScriptSource source) {
        this.id = id;
        this.context = context;
        this.content = content;
        this.mediaType = Objects.requireNonNull(mediaType);
        this.source = source;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null || this.id.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"must specify id for stored script", validationException);
        } else if (this.id.contains("#")) {
            validationException = ValidateActions.addValidationError((String)"id cannot contain '#' for stored script", (ActionRequestValidationException)validationException);
        }
        if (this.content == null) {
            validationException = ValidateActions.addValidationError((String)"must specify code for stored script", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String id() {
        return this.id;
    }

    public PutStoredScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    public String context() {
        return this.context;
    }

    public PutStoredScriptRequest context(String context) {
        this.context = context;
        return this;
    }

    public BytesReference content() {
        return this.content;
    }

    public MediaType mediaType() {
        return this.mediaType;
    }

    public StoredScriptSource source() {
        return this.source;
    }

    public PutStoredScriptRequest content(BytesReference content, MediaType mediaType) {
        this.content = content;
        this.mediaType = Objects.requireNonNull(mediaType);
        this.source = StoredScriptSource.parse(content, mediaType);
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.id);
        out.writeBytesReference(this.content);
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_10_0)) {
            this.mediaType.writeTo(out);
        } else {
            out.writeVInt(MetadataStateFormat.XCONTENT_TYPE_BWC_PROVIDER.getOrdinalByXContentType(this.mediaType));
        }
        out.writeOptionalString(this.context);
        this.source.writeTo(out);
    }

    public String toString() {
        String source = "_na_";
        try {
            source = XContentHelper.convertToJson(this.content, false, this.mediaType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "put stored script {id [" + this.id + "]" + (String)(this.context != null ? ", context [" + this.context + "]" : "") + ", content [" + source + "]}";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("script");
        this.source.toXContent(builder, params);
        return builder;
    }
}

