/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.close;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.clustermanager.AcknowledgedRequest;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.util.CollectionUtils;
import java.io.IOException;

public class CloseIndexRequest
extends AcknowledgedRequest<CloseIndexRequest>
implements IndicesRequest.Replaceable {
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();
    private ActiveShardCount waitForActiveShards = ActiveShardCount.NONE;

    public CloseIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
    }

    public CloseIndexRequest() {
    }

    public CloseIndexRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (CollectionUtils.isEmpty(this.indices)) {
            validationException = ValidateActions.addValidationError((String)"index is missing", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public CloseIndexRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public CloseIndexRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public CloseIndexRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        this.waitForActiveShards.writeTo(out);
    }
}

