/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.exists;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeReadRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class IndicesExistsRequest
extends ClusterManagerNodeReadRequest<IndicesExistsRequest>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, true);

    public IndicesExistsRequest() {
    }

    public IndicesExistsRequest(String ... indices) {
        this.indices = indices;
    }

    public IndicesExistsRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesExistsRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public IndicesExistsRequest expandWilcardsOpen(boolean expandWildcardsOpen) {
        this.indicesOptions = IndicesOptions.fromOptions(this.indicesOptions.ignoreUnavailable(), this.indicesOptions.allowNoIndices(), expandWildcardsOpen, this.indicesOptions.expandWildcardsClosed());
        return this;
    }

    public IndicesExistsRequest expandWilcardsClosed(boolean expandWildcardsClosed) {
        this.indicesOptions = IndicesOptions.fromOptions(this.indicesOptions.ignoreUnavailable(), this.indicesOptions.allowNoIndices(), this.indicesOptions.expandWildcardsOpen(), expandWildcardsClosed);
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices == null || this.indices.length == 0) {
            validationException = ValidateActions.addValidationError((String)"index/indices is missing", validationException);
        }
        return validationException;
    }
}

