/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.flush;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.support.broadcast.BroadcastRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class FlushRequest
extends BroadcastRequest<FlushRequest> {
    private boolean force = false;
    private boolean waitIfOngoing = true;

    public FlushRequest(String ... indices) {
        super(indices);
    }

    public FlushRequest(StreamInput in) throws IOException {
        super(in);
        this.force = in.readBoolean();
        this.waitIfOngoing = in.readBoolean();
    }

    public boolean waitIfOngoing() {
        return this.waitIfOngoing;
    }

    public FlushRequest waitIfOngoing(boolean waitIfOngoing) {
        this.waitIfOngoing = waitIfOngoing;
        return this;
    }

    public boolean force() {
        return this.force;
    }

    public FlushRequest force(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationError = super.validate();
        if (this.force && !this.waitIfOngoing) {
            validationError = ValidateActions.addValidationError((String)"wait_if_ongoing must be true for a force flush", (ActionRequestValidationException)validationError);
        }
        return validationError;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.force);
        out.writeBoolean(this.waitIfOngoing);
    }

    public String toString() {
        return "FlushRequest{waitIfOngoing=" + this.waitIfOngoing + ", force=" + this.force + "}";
    }
}

