/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.forcemerge;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.UUIDs;
import io.skylite.core.action.support.broadcast.BroadcastRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.Arrays;

public class ForceMergeRequest
extends BroadcastRequest<ForceMergeRequest> {
    private int maxNumSegments = -1;
    private boolean onlyExpungeDeletes = false;
    private boolean flush = true;
    private static final Version FORCE_MERGE_UUID_VERSION = OpenSearchVersion.V_3_0_0;
    public static final String FORCE_MERGE_UUID_KEY = "force_merge_uuid";
    private final String forceMergeUUID;
    private boolean shouldStoreResult;

    public ForceMergeRequest(String ... indices) {
        super(indices);
        this.forceMergeUUID = UUIDs.randomBase64UUID();
    }

    public ForceMergeRequest(StreamInput in) throws IOException {
        super(in);
        this.maxNumSegments = in.readInt();
        this.onlyExpungeDeletes = in.readBoolean();
        this.flush = in.readBoolean();
        if (in.getVersion().onOrAfter(FORCE_MERGE_UUID_VERSION)) {
            this.forceMergeUUID = in.readString();
        } else {
            this.forceMergeUUID = in.readOptionalString();
            if (this.forceMergeUUID == null) {
                throw new IllegalStateException("As of legacy version 7.7 [force_merge_uuid] is no longer optional in force merge requests.");
            }
        }
    }

    public int maxNumSegments() {
        return this.maxNumSegments;
    }

    public ForceMergeRequest maxNumSegments(int maxNumSegments) {
        this.maxNumSegments = maxNumSegments;
        return this;
    }

    public boolean onlyExpungeDeletes() {
        return this.onlyExpungeDeletes;
    }

    public ForceMergeRequest onlyExpungeDeletes(boolean onlyExpungeDeletes) {
        this.onlyExpungeDeletes = onlyExpungeDeletes;
        return this;
    }

    public String forceMergeUUID() {
        return this.forceMergeUUID;
    }

    public boolean flush() {
        return this.flush;
    }

    public ForceMergeRequest flush(boolean flush) {
        this.flush = flush;
        return this;
    }

    public void setShouldStoreResult(boolean shouldStoreResult) {
        this.shouldStoreResult = shouldStoreResult;
    }

    @Override
    public boolean getShouldStoreResult() {
        return this.shouldStoreResult;
    }

    @Override
    public String getDescription() {
        return "Force-merge indices " + Arrays.toString(this.indices()) + ", maxSegments[" + this.maxNumSegments + "], onlyExpungeDeletes[" + this.onlyExpungeDeletes + "], flush[" + this.flush + "]";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.maxNumSegments);
        out.writeBoolean(this.onlyExpungeDeletes);
        out.writeBoolean(this.flush);
        if (out.getVersion().onOrAfter(FORCE_MERGE_UUID_VERSION)) {
            out.writeString(this.forceMergeUUID);
        } else {
            out.writeOptionalString(this.forceMergeUUID);
        }
    }

    public String toString() {
        return "ForceMergeRequest{maxNumSegments=" + this.maxNumSegments + ", onlyExpungeDeletes=" + this.onlyExpungeDeletes + ", flush=" + this.flush + "}";
    }

    public static final class Defaults {
        public static final int MAX_NUM_SEGMENTS = -1;
        public static final boolean ONLY_EXPUNGE_DELETES = false;
        public static final boolean FLUSH = true;
    }
}

