/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.mapping.get;

import io.skylite.OpenSearchVersion;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.OriginalIndices;
import io.skylite.core.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.action.support.single.shard.SingleShardRequest;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class GetFieldMappingsIndexRequest
extends SingleShardRequest<GetFieldMappingsIndexRequest> {
    private final boolean includeDefaults;
    private final String[] fields;
    private final OriginalIndices originalIndices;

    public GetFieldMappingsIndexRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().before(OpenSearchVersion.V_2_0_0)) {
            in.readStringArray();
        }
        this.fields = in.readStringArray();
        this.includeDefaults = in.readBoolean();
        if (in.getVersion().before(OpenSearchVersion.V_2_0_0)) {
            in.readBoolean();
        }
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    public GetFieldMappingsIndexRequest(GetFieldMappingsRequest other, String index) {
        this.includeDefaults = other.includeDefaults();
        this.fields = other.fields();
        assert (index != null);
        this.index(index);
        this.originalIndices = new OriginalIndices(other);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String[] fields() {
        return this.fields;
    }

    public boolean includeDefaults() {
        return this.includeDefaults;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(OpenSearchVersion.V_2_0_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        out.writeStringArray(this.fields);
        out.writeBoolean(this.includeDefaults);
        if (out.getVersion().before(OpenSearchVersion.V_2_0_0)) {
            out.writeBoolean(false);
        }
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }
}

