/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.open;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.clustermanager.AcknowledgedRequest;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.util.CollectionUtils;
import java.io.IOException;
import java.util.Arrays;

public class OpenIndexRequest
extends AcknowledgedRequest<OpenIndexRequest>
implements IndicesRequest.Replaceable {
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, true, false, true);
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;
    private boolean shouldStoreResult;

    public OpenIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
    }

    public OpenIndexRequest() {
    }

    public OpenIndexRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (CollectionUtils.isEmpty(this.indices)) {
            validationException = ValidateActions.addValidationError((String)"index is missing", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public OpenIndexRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public OpenIndexRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public OpenIndexRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public OpenIndexRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public void setShouldStoreResult(boolean shouldStoreResult) {
        this.shouldStoreResult = shouldStoreResult;
    }

    @Override
    public boolean getShouldStoreResult() {
        return this.shouldStoreResult;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        this.waitForActiveShards.writeTo(out);
    }

    public String toString() {
        return "open indices " + Arrays.toString(this.indices());
    }

    @Override
    public String getDescription() {
        return this.toString();
    }
}

