/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.readonly;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.clustermanager.AcknowledgedRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.cluster.metadata.IndexMetadataAPIBlock;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.util.CollectionUtils;
import java.io.IOException;
import java.util.Objects;

public class AddIndexBlockRequest
extends AcknowledgedRequest<AddIndexBlockRequest>
implements IndicesRequest.Replaceable {
    private final IndexMetadataAPIBlock block;
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public AddIndexBlockRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.block = IndexMetadataAPIBlock.readFrom(in);
    }

    public AddIndexBlockRequest(IndexMetadataAPIBlock block, String ... indices) {
        this.block = Objects.requireNonNull(block);
        this.indices = Objects.requireNonNull(indices);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (CollectionUtils.isEmpty(this.indices)) {
            validationException = ValidateActions.addValidationError((String)"index is missing", validationException);
        }
        if (this.block == IndexMetadataAPIBlock.READ_ONLY_ALLOW_DELETE) {
            validationException = ValidateActions.addValidationError((String)"read_only_allow_delete block is for internal use only", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public AddIndexBlockRequest indices(String ... indices) {
        this.indices = Objects.requireNonNull(indices);
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public AddIndexBlockRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public IndexMetadataAPIBlock getBlock() {
        return this.block;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        this.block.writeTo(out);
    }
}

