/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.readonly;

import io.skylite.SkyliteException;
import io.skylite.common.Nullable;
import io.skylite.core.action.clustermanager.ShardsAcknowledgedResponse;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.index.Index;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AddIndexBlockResponse
extends ShardsAcknowledgedResponse {
    private final List<AddBlockResult> indices;

    public AddIndexBlockResponse(StreamInput in) throws IOException {
        super(in, true);
        this.indices = Collections.unmodifiableList(in.readList(AddBlockResult::new));
    }

    public AddIndexBlockResponse(boolean acknowledged, boolean shardsAcknowledged, List<AddBlockResult> indices) {
        super(acknowledged, shardsAcknowledged);
        this.indices = Collections.unmodifiableList(Objects.requireNonNull(indices));
    }

    public List<AddBlockResult> getIndices() {
        return this.indices;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeShardsAcknowledged(out);
        out.writeList(this.indices);
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addCustomFields(builder, params);
        builder.startArray("indices");
        for (AddBlockResult index : this.indices) {
            index.toXContent(builder, params);
        }
        builder.endArray();
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    public static class AddBlockResult
    implements Writeable,
    ToXContentFragment {
        private final Index index;
        @Nullable
        private final Exception exception;
        @Nullable
        private final AddBlockShardResult[] shards;

        public AddBlockResult(Index index) {
            this(index, null, null);
        }

        public AddBlockResult(Index index, Exception failure) {
            this(index, Objects.requireNonNull(failure), null);
        }

        public AddBlockResult(Index index, AddBlockShardResult[] shards) {
            this(index, null, Objects.requireNonNull(shards));
        }

        private AddBlockResult(Index index, @Nullable Exception exception, @Nullable AddBlockShardResult[] shards) {
            this.index = Objects.requireNonNull(index);
            this.exception = exception;
            this.shards = shards;
        }

        AddBlockResult(StreamInput in) throws IOException {
            this.index = new Index(in);
            this.exception = in.readException();
            this.shards = in.readOptionalArray(AddBlockShardResult::new, AddBlockShardResult[]::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.index.writeTo(out);
            out.writeException(this.exception);
            out.writeOptionalArray(this.shards);
        }

        public Index getIndex() {
            return this.index;
        }

        public Exception getException() {
            return this.exception;
        }

        public AddBlockShardResult[] getShards() {
            return this.shards;
        }

        public boolean hasFailures() {
            if (this.exception != null) {
                return true;
            }
            if (this.shards != null) {
                for (AddBlockShardResult shard : this.shards) {
                    if (!shard.hasFailures()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.index.getName());
            if (this.hasFailures()) {
                if (this.exception != null) {
                    builder.startObject("exception");
                    SkyliteException.generateFailureXContent(builder, params, this.exception, true);
                    builder.endObject();
                } else {
                    builder.startArray("failed_shards");
                    for (AddBlockShardResult shard : this.shards) {
                        if (!shard.hasFailures()) continue;
                        shard.toXContent(builder, params);
                    }
                    builder.endArray();
                }
            } else {
                builder.field("blocked", true);
            }
            return builder.endObject();
        }

        public String toString() {
            return Strings.toString(MediaTypeRegistry.JSON, this);
        }
    }

    public static class AddBlockShardResult
    implements Writeable,
    ToXContentFragment {
        private final int id;
        private final Failure[] failures;

        public AddBlockShardResult(int id, Failure[] failures) {
            this.id = id;
            this.failures = failures;
        }

        AddBlockShardResult(StreamInput in) throws IOException {
            this.id = in.readVInt();
            this.failures = in.readOptionalArray(Failure::readFailure, Failure[]::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.id);
            out.writeOptionalArray(this.failures);
        }

        public boolean hasFailures() {
            return !CollectionUtils.isEmpty(this.failures);
        }

        public int getId() {
            return this.id;
        }

        public Failure[] getFailures() {
            return this.failures;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("id", String.valueOf(this.id));
            builder.startArray("failures");
            if (this.failures != null) {
                for (Failure failure : this.failures) {
                    failure.toXContent(builder, params);
                }
            }
            builder.endArray();
            return builder.endObject();
        }

        public String toString() {
            return Strings.toString(MediaTypeRegistry.JSON, this);
        }

        public static class Failure
        extends DefaultShardOperationFailedException {
            @Nullable
            private String nodeId;

            private Failure(StreamInput in) throws IOException {
                super(in);
                this.nodeId = in.readOptionalString();
            }

            public Failure(String index, int shardId, Throwable reason) {
                this(index, shardId, reason, null);
            }

            public Failure(String index, int shardId, Throwable reason, String nodeId) {
                super(index, shardId, reason);
                this.nodeId = nodeId;
            }

            public String getNodeId() {
                return this.nodeId;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeOptionalString(this.nodeId);
            }

            @Override
            public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (this.nodeId != null) {
                    builder.field("node", this.nodeId);
                }
                return super.innerToXContent(builder, params);
            }

            @Override
            public String toString() {
                return Strings.toString(MediaTypeRegistry.JSON, this);
            }

            static Failure readFailure(StreamInput in) throws IOException {
                return new Failure(in);
            }
        }
    }
}

