/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.resolve;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ResolveIndexAction
extends ActionType<Response> {
    public static final ResolveIndexAction INSTANCE = new ResolveIndexAction();
    public static final String NAME = "indices:admin/resolve/index";

    private ResolveIndexAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
        static final ParseField ALIASES_FIELD = new ParseField("aliases", new String[0]);
        static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private final List<ResolvedIndex> indices;
        private final List<ResolvedAlias> aliases;
        private final List<ResolvedDataStream> dataStreams;

        public Response(List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams) {
            this.indices = indices;
            this.aliases = aliases;
            this.dataStreams = dataStreams;
        }

        public Response(StreamInput in) throws IOException {
            this.indices = in.readList(ResolvedIndex::new);
            this.aliases = in.readList(ResolvedAlias::new);
            this.dataStreams = in.readList(ResolvedDataStream::new);
        }

        public List<ResolvedIndex> getIndices() {
            return this.indices;
        }

        public List<ResolvedAlias> getAliases() {
            return this.aliases;
        }

        public List<ResolvedDataStream> getDataStreams() {
            return this.dataStreams;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.indices);
            out.writeList(this.aliases);
            out.writeList(this.dataStreams);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDICES_FIELD.getPreferredName(), this.indices);
            builder.field(ALIASES_FIELD.getPreferredName(), this.aliases);
            builder.field(DATA_STREAMS_FIELD.getPreferredName(), this.dataStreams);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.indices.equals(response.indices) && this.aliases.equals(response.aliases) && this.dataStreams.equals(response.dataStreams);
        }

        public int hashCode() {
            return Objects.hash(this.indices, this.aliases, this.dataStreams);
        }
    }

    public static class ResolvedDataStream
    extends ResolvedIndexAbstraction
    implements Writeable,
    ToXContentObject {
        static final ParseField BACKING_INDICES_FIELD = new ParseField("backing_indices", new String[0]);
        static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp_field", new String[0]);
        private final String[] backingIndices;
        private final String timestampField;

        ResolvedDataStream(StreamInput in) throws IOException {
            this.setName(in.readString());
            this.backingIndices = in.readStringArray();
            this.timestampField = in.readString();
        }

        public ResolvedDataStream(String name, String[] backingIndices, String timestampField) {
            super(name);
            this.backingIndices = backingIndices;
            this.timestampField = timestampField;
        }

        public ResolvedDataStream copy(String newName) {
            return new ResolvedDataStream(newName, this.backingIndices, this.timestampField);
        }

        public String[] getBackingIndices() {
            return this.backingIndices;
        }

        public String getTimestampField() {
            return this.timestampField;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getName());
            out.writeStringArray(this.backingIndices);
            out.writeString(this.timestampField);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.getName());
            builder.array(BACKING_INDICES_FIELD.getPreferredName(), this.backingIndices);
            builder.field(TIMESTAMP_FIELD.getPreferredName(), this.timestampField);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedDataStream dataStream = (ResolvedDataStream)o;
            return this.getName().equals(dataStream.getName()) && this.timestampField.equals(dataStream.timestampField) && Arrays.equals(this.backingIndices, dataStream.backingIndices);
        }

        public int hashCode() {
            int result = Objects.hash(this.getName(), this.timestampField);
            result = 31 * result + Arrays.hashCode(this.backingIndices);
            return result;
        }
    }

    public static class ResolvedAlias
    extends ResolvedIndexAbstraction
    implements Writeable,
    ToXContentObject {
        static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
        private final String[] indices;

        ResolvedAlias(StreamInput in) throws IOException {
            this.setName(in.readString());
            this.indices = in.readStringArray();
        }

        public ResolvedAlias(String name, String[] indices) {
            super(name);
            this.indices = indices;
        }

        public ResolvedAlias copy(String newName) {
            return new ResolvedAlias(newName, this.indices);
        }

        public String[] getIndices() {
            return this.indices;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getName());
            out.writeStringArray(this.indices);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.getName());
            if (this.indices.length > 0) {
                builder.array(INDICES_FIELD.getPreferredName(), this.indices);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedAlias alias = (ResolvedAlias)o;
            return this.getName().equals(alias.getName()) && Arrays.equals(this.indices, alias.indices);
        }

        public int hashCode() {
            int result = Objects.hash(this.getName());
            result = 31 * result + Arrays.hashCode(this.indices);
            return result;
        }
    }

    public static class ResolvedIndex
    extends ResolvedIndexAbstraction
    implements Writeable,
    ToXContentObject {
        static final ParseField ALIASES_FIELD = new ParseField("aliases", new String[0]);
        static final ParseField ATTRIBUTES_FIELD = new ParseField("attributes", new String[0]);
        static final ParseField DATA_STREAM_FIELD = new ParseField("data_stream", new String[0]);
        private final String[] aliases;
        private final String[] attributes;
        private final String dataStream;

        ResolvedIndex(StreamInput in) throws IOException {
            this.setName(in.readString());
            this.aliases = in.readStringArray();
            this.attributes = in.readStringArray();
            this.dataStream = in.readOptionalString();
        }

        public ResolvedIndex(String name, String[] aliases, String[] attributes, @Nullable String dataStream) {
            super(name);
            this.aliases = aliases;
            this.attributes = attributes;
            this.dataStream = dataStream;
        }

        public ResolvedIndex copy(String newName) {
            return new ResolvedIndex(newName, this.aliases, this.attributes, this.dataStream);
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public String[] getAttributes() {
            return this.attributes;
        }

        public String getDataStream() {
            return this.dataStream;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getName());
            out.writeStringArray(this.aliases);
            out.writeStringArray(this.attributes);
            out.writeOptionalString(this.dataStream);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.getName());
            if (this.aliases.length > 0) {
                builder.array(ALIASES_FIELD.getPreferredName(), this.aliases);
            }
            builder.array(ATTRIBUTES_FIELD.getPreferredName(), this.attributes);
            if (!Strings.isNullOrEmpty(this.dataStream)) {
                builder.field(DATA_STREAM_FIELD.getPreferredName(), this.dataStream);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedIndex index = (ResolvedIndex)o;
            return this.getName().equals(index.getName()) && Objects.equals(this.dataStream, index.dataStream) && Arrays.equals(this.aliases, index.aliases) && Arrays.equals(this.attributes, index.attributes);
        }

        public int hashCode() {
            int result = Objects.hash(this.getName(), this.dataStream);
            result = 31 * result + Arrays.hashCode(this.aliases);
            result = 31 * result + Arrays.hashCode(this.attributes);
            return result;
        }
    }

    public static class ResolvedIndexAbstraction {
        static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
        private String name;

        ResolvedIndexAbstraction() {
        }

        ResolvedIndexAbstraction(String name) {
            this.name = name;
        }

        protected void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Request
    extends ActionRequest
    implements IndicesRequest.Replaceable {
        public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpen();
        private String[] names;
        private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;

        public Request(String[] names) {
            this.names = names;
        }

        public Request(String[] names, IndicesOptions indicesOptions) {
            this.names = names;
            this.indicesOptions = indicesOptions;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names);
        }

        public int hashCode() {
            return Arrays.hashCode(this.names);
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }
    }
}

