/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.segments;

import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.engine.Segment;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class ShardSegments
implements Writeable,
Iterable<Segment> {
    private final ShardRouting shardRouting;
    private final List<Segment> segments;

    public ShardSegments(ShardRouting shardRouting, List<Segment> segments) {
        this.shardRouting = shardRouting;
        this.segments = segments;
    }

    public ShardSegments(StreamInput in) throws IOException {
        this.shardRouting = new ShardRouting(in);
        this.segments = in.readList(Segment::new);
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.segments.iterator();
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public int getNumberOfCommitted() {
        int count = 0;
        for (Segment segment : this.segments) {
            if (!segment.isCommitted()) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfSearch() {
        int count = 0;
        for (Segment segment : this.segments) {
            if (!segment.isSearch()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        out.writeList(this.segments);
    }
}

