/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.template.get;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.clustermanager.ClusterManagerNodeReadRequest;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class GetIndexTemplatesRequest
extends ClusterManagerNodeReadRequest<GetIndexTemplatesRequest> {
    private String[] names;

    public GetIndexTemplatesRequest() {
    }

    public GetIndexTemplatesRequest(String ... names) {
        this.names = names;
    }

    public GetIndexTemplatesRequest(StreamInput in) throws IOException {
        super(in);
        this.names = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.names);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.names == null) {
            validationException = ValidateActions.addValidationError((String)"names is null or empty", validationException);
        } else {
            for (String name : this.names) {
                if (name != null && Strings.hasText(name)) continue;
                validationException = ValidateActions.addValidationError((String)"name is missing", (ActionRequestValidationException)validationException);
            }
        }
        return validationException;
    }

    public GetIndexTemplatesRequest names(String ... names) {
        this.names = names;
        return this;
    }

    public String[] names() {
        return this.names;
    }
}

