/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.template.put;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.cluster.metadata.ComposableIndexTemplate;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.regex.Regex;
import java.io.IOException;
import java.util.Objects;

public class PutComposableIndexTemplateAction
extends ActionType<AcknowledgedResponse> {
    public static final PutComposableIndexTemplateAction INSTANCE = new PutComposableIndexTemplateAction();
    public static final String NAME = "indices:admin/index_template/put";

    private PutComposableIndexTemplateAction() {
        super(NAME, AcknowledgedResponse::new);
    }

    public static class Request
    extends ClusterManagerNodeRequest<Request>
    implements IndicesRequest {
        private final String name;
        @Nullable
        private String cause;
        private boolean create;
        private ComposableIndexTemplate indexTemplate;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.cause = in.readOptionalString();
            this.create = in.readBoolean();
            this.indexTemplate = new ComposableIndexTemplate(in);
        }

        public Request(String name) {
            this.name = name;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeOptionalString(this.cause);
            out.writeBoolean(this.create);
            this.indexTemplate.writeTo(out);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.name == null || !Strings.hasText(this.name)) {
                validationException = ValidateActions.addValidationError((String)"name is missing", validationException);
            }
            validationException = this.validateIndexTemplate(validationException);
            return validationException;
        }

        public ActionRequestValidationException validateIndexTemplate(@Nullable ActionRequestValidationException validationException) {
            if (this.indexTemplate == null) {
                validationException = ValidateActions.addValidationError((String)"an index template is required", (ActionRequestValidationException)validationException);
            } else {
                if (this.indexTemplate.indexPatterns().stream().anyMatch(Regex::isMatchAllPattern) && IndexMetadata.INDEX_HIDDEN_SETTING.exists(this.indexTemplate.template().settings())) {
                    validationException = ValidateActions.addValidationError((String)("global composable templates may not specify the setting " + IndexMetadata.INDEX_HIDDEN_SETTING.getKey()), (ActionRequestValidationException)validationException);
                }
                if (this.indexTemplate.priority() != null && this.indexTemplate.priority() < 0L) {
                    validationException = ValidateActions.addValidationError((String)"index template priority must be >= 0", (ActionRequestValidationException)validationException);
                }
            }
            return validationException;
        }

        public String name() {
            return this.name;
        }

        public Request create(boolean create) {
            this.create = create;
            return this;
        }

        public boolean create() {
            return this.create;
        }

        public Request cause(@Nullable String cause) {
            this.cause = cause;
            return this;
        }

        @Nullable
        public String cause() {
            return this.cause;
        }

        public Request indexTemplate(ComposableIndexTemplate template) {
            this.indexTemplate = template;
            return this;
        }

        public ComposableIndexTemplate indexTemplate() {
            return this.indexTemplate;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PutTemplateV2Request[");
            sb.append("name=").append(this.name);
            sb.append(", cause=").append(this.cause);
            sb.append(", create=").append(this.create);
            sb.append(", index_template=").append(this.indexTemplate);
            sb.append("]");
            return sb.toString();
        }

        @Override
        public String[] indices() {
            return this.indexTemplate.indexPatterns().toArray(Strings.EMPTY_ARRAY);
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictExpand();
        }

        public int hashCode() {
            return Objects.hash(this.name, this.cause, this.create, this.indexTemplate);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.cause, other.cause) && Objects.equals(this.indexTemplate, other.indexTemplate) && this.create == other.create;
        }
    }
}

