/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.upgrade.get;

import io.skylite.core.action.admin.indices.upgrade.get.IndexShardUpgradeStatus;
import io.skylite.core.action.admin.indices.upgrade.get.ShardUpgradeStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IndexUpgradeStatus
implements Iterable<IndexShardUpgradeStatus> {
    private final String index;
    private final Map<Integer, IndexShardUpgradeStatus> indexShards;

    IndexUpgradeStatus(String index, ShardUpgradeStatus[] shards) {
        this.index = index;
        HashMap<Integer, ArrayList<ShardUpgradeStatus>> tmpIndexShards = new HashMap<Integer, ArrayList<ShardUpgradeStatus>>();
        for (ShardUpgradeStatus shard : shards) {
            ArrayList<ShardUpgradeStatus> lst = (ArrayList<ShardUpgradeStatus>)tmpIndexShards.get(shard.getShardRouting().id());
            if (lst == null) {
                lst = new ArrayList<ShardUpgradeStatus>();
                tmpIndexShards.put(shard.getShardRouting().id(), lst);
            }
            lst.add(shard);
        }
        this.indexShards = new HashMap<Integer, IndexShardUpgradeStatus>();
        for (Map.Entry entry : tmpIndexShards.entrySet()) {
            this.indexShards.put((Integer)entry.getKey(), new IndexShardUpgradeStatus(((ShardUpgradeStatus)((List)entry.getValue()).get(0)).getShardRouting().shardId(), ((List)entry.getValue()).toArray(new ShardUpgradeStatus[0])));
        }
    }

    public String getIndex() {
        return this.index;
    }

    public Map<Integer, IndexShardUpgradeStatus> getShards() {
        return this.indexShards;
    }

    @Override
    public Iterator<IndexShardUpgradeStatus> iterator() {
        return this.indexShards.values().iterator();
    }

    public long getTotalBytes() {
        long totalBytes = 0L;
        for (IndexShardUpgradeStatus indexShardUpgradeStatus : this.indexShards.values()) {
            totalBytes += indexShardUpgradeStatus.getTotalBytes();
        }
        return totalBytes;
    }

    public long getToUpgradeBytes() {
        long upgradeBytes = 0L;
        for (IndexShardUpgradeStatus indexShardUpgradeStatus : this.indexShards.values()) {
            upgradeBytes += indexShardUpgradeStatus.getToUpgradeBytes();
        }
        return upgradeBytes;
    }

    public long getToUpgradeBytesAncient() {
        long upgradeBytesAncient = 0L;
        for (IndexShardUpgradeStatus indexShardUpgradeStatus : this.indexShards.values()) {
            upgradeBytesAncient += indexShardUpgradeStatus.getToUpgradeBytesAncient();
        }
        return upgradeBytesAncient;
    }
}

