/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.upgrade.post;

import io.skylite.Version;
import io.skylite.common.collect.Tuple;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.broadcast.BroadcastResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class UpgradeResponse
extends BroadcastResponse {
    private final Map<String, Tuple<Version, String>> versions;

    UpgradeResponse(StreamInput in) throws IOException {
        super(in);
        this.versions = in.readMap(StreamInput::readString, i -> Tuple.tuple((Object)i.readVersion(), (Object)i.readString()));
    }

    public UpgradeResponse(Map<String, Tuple<Version, String>> versions, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.versions = versions;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.versions, StreamOutput::writeString, (o, v) -> {
            o.writeVersion((Version)v.v1());
            o.writeString((String)v.v2());
        });
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("upgraded_indices");
        for (Map.Entry<String, Tuple<Version, String>> entry : this.versions.entrySet()) {
            builder.startObject(entry.getKey());
            builder.field("upgrade_version", (ToXContent)entry.getValue().v1());
            builder.field("oldest_lucene_segment_version", (String)entry.getValue().v2());
            builder.endObject();
        }
        builder.endObject();
    }

    public Map<String, Tuple<Version, String>> versions() {
        return this.versions;
    }
}

