/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.validate;

import io.skylite.core.ParseField;
import io.skylite.core.action.admin.indices.validate.QueryExplanation;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.broadcast.BroadcastResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ValidateQueryResponse
extends BroadcastResponse {
    public static final String VALID_FIELD = "valid";
    public static final String EXPLANATIONS_FIELD = "explanations";
    static final ConstructingObjectParser<ValidateQueryResponse, Void> PARSER = new ConstructingObjectParser("validate_query", true, arg -> {
        BroadcastResponse response = (BroadcastResponse)arg[0];
        return new ValidateQueryResponse((Boolean)arg[1], (List)arg[2], response.getTotalShards(), response.getSuccessfulShards(), response.getFailedShards(), Arrays.asList(response.getShardFailures()));
    });
    private final boolean valid;
    private final List<QueryExplanation> queryExplanations;

    ValidateQueryResponse(StreamInput in) throws IOException {
        super(in);
        this.valid = in.readBoolean();
        this.queryExplanations = in.readList(QueryExplanation::new);
    }

    public ValidateQueryResponse(boolean valid, List<QueryExplanation> queryExplanations, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.valid = valid;
        this.queryExplanations = queryExplanations == null ? Collections.emptyList() : queryExplanations;
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<? extends QueryExplanation> getQueryExplanation() {
        return this.queryExplanations;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.valid);
        out.writeCollection(this.queryExplanations);
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(VALID_FIELD, this.isValid());
        if (this.getQueryExplanation() != null && !this.getQueryExplanation().isEmpty()) {
            builder.startArray(EXPLANATIONS_FIELD);
            for (QueryExplanation queryExplanation : this.getQueryExplanation()) {
                builder.startObject();
                queryExplanation.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    public static ValidateQueryResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        ValidateQueryResponse.declareBroadcastFields(PARSER);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField(VALID_FIELD, new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), QueryExplanation.PARSER, new ParseField(EXPLANATIONS_FIELD, new String[0]));
    }
}

