/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.bulk;

import io.skylite.common.Nullable;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.xcontent.MediaTypeRegistry;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class BulkItemRequest
implements Writeable,
Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(BulkItemRequest.class);
    private int id;
    private DocWriteRequest<?> request;
    private volatile BulkItemResponse primaryResponse;

    BulkItemRequest(@Nullable ShardId shardId, StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.request = DocWriteRequest.readDocumentRequest(shardId, in);
        if (in.readBoolean()) {
            this.primaryResponse = shardId == null ? new BulkItemResponse(in) : new BulkItemResponse(shardId, in);
        }
    }

    public BulkItemRequest(int id, DocWriteRequest<?> request) {
        this.id = id;
        this.request = request;
    }

    public int id() {
        return this.id;
    }

    public DocWriteRequest<?> request() {
        return this.request;
    }

    public String index() {
        assert (this.request.indices().length == 1);
        return this.request.indices()[0];
    }

    public BulkItemResponse getPrimaryResponse() {
        return this.primaryResponse;
    }

    public void setPrimaryResponse(BulkItemResponse primaryResponse) {
        this.primaryResponse = primaryResponse;
    }

    public void abort(String index, Exception cause) {
        if (this.primaryResponse == null) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(index, this.request.id(), Objects.requireNonNull(cause), true);
            this.setPrimaryResponse(new BulkItemResponse(this.id, this.request.opType(), failure));
        } else {
            assert (this.primaryResponse.isFailed() && this.primaryResponse.getFailure().isAborted()) : "response [" + Strings.toString(MediaTypeRegistry.JSON, this.primaryResponse) + "]; cause [" + String.valueOf(cause) + "]";
            if (this.primaryResponse.isFailed() && this.primaryResponse.getFailure().isAborted()) {
                this.primaryResponse.getFailure().getCause().addSuppressed(cause);
            } else {
                throw new IllegalStateException("aborting item that with response [" + String.valueOf(this.primaryResponse) + "] that was previously processed", cause);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        DocWriteRequest.writeDocumentRequest(out, this.request);
        out.writeOptionalWriteable(this.primaryResponse);
    }

    public void writeThin(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        DocWriteRequest.writeDocumentRequestThin(out, this.request);
        out.writeOptionalWriteable(this.primaryResponse == null ? null : this.primaryResponse::writeThin);
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.request.ramBytesUsed();
    }
}

