/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.fieldcaps;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

public final class FieldCapabilitiesRequest
extends ActionRequest
implements IndicesRequest.Replaceable,
ToXContentObject {
    public static final String NAME = "field_caps_request";
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();
    private String[] fields = Strings.EMPTY_ARRAY;
    private boolean includeUnmapped = false;
    private boolean mergeResults = true;
    private QueryBuilder indexFilter;
    private Long nowInMillis;

    public FieldCapabilitiesRequest(StreamInput in) throws IOException {
        super(in);
        this.fields = in.readStringArray();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.mergeResults = in.readBoolean();
        this.includeUnmapped = in.readBoolean();
        this.indexFilter = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nowInMillis = in.readOptionalLong();
    }

    public FieldCapabilitiesRequest() {
    }

    public boolean isMergeResults() {
        return this.mergeResults;
    }

    public void setMergeResults(boolean mergeResults) {
        this.mergeResults = mergeResults;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.fields);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeBoolean(this.mergeResults);
        out.writeBoolean(this.includeUnmapped);
        out.writeOptionalNamedWriteable(this.indexFilter);
        out.writeOptionalLong(this.nowInMillis);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.indexFilter != null) {
            builder.field("index_filter", this.indexFilter);
        }
        builder.endObject();
        return builder;
    }

    public FieldCapabilitiesRequest fields(String ... fields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("specified fields can't be null or empty");
        }
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(fields));
        this.fields = fieldSet.toArray(new String[0]);
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    @Override
    public FieldCapabilitiesRequest indices(String ... indices) {
        this.indices = Objects.requireNonNull(indices, "indices must not be null");
        return this;
    }

    public FieldCapabilitiesRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "indices options must not be null");
        return this;
    }

    public FieldCapabilitiesRequest includeUnmapped(boolean includeUnmapped) {
        this.includeUnmapped = includeUnmapped;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public boolean includeUnmapped() {
        return this.includeUnmapped;
    }

    public FieldCapabilitiesRequest indexFilter(QueryBuilder indexFilter) {
        this.indexFilter = indexFilter;
        return this;
    }

    public QueryBuilder indexFilter() {
        return this.indexFilter;
    }

    public Long nowInMillis() {
        return this.nowInMillis;
    }

    public void nowInMillis(long nowInMillis) {
        this.nowInMillis = nowInMillis;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.fields == null || this.fields.length == 0) {
            validationException = ValidateActions.addValidationError((String)"no fields specified", validationException);
        }
        return validationException;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesRequest that = (FieldCapabilitiesRequest)o;
        return this.includeUnmapped == that.includeUnmapped && this.mergeResults == that.mergeResults && Arrays.equals(this.indices, that.indices) && this.indicesOptions.equals(that.indicesOptions) && Arrays.equals(this.fields, that.fields) && Objects.equals(this.indexFilter, that.indexFilter) && Objects.equals(this.nowInMillis, that.nowInMillis);
    }

    public int hashCode() {
        int result = Objects.hash(this.indicesOptions, this.includeUnmapped, this.mergeResults, this.indexFilter, this.nowInMillis);
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.fields);
        return result;
    }
}

