/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.get;

import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultiGetShardResponse
extends ActionResponse {
    final List<Integer> locations;
    final List<GetResponse> responses;
    final List<MultiGetResponse.Failure> failures;

    public MultiGetShardResponse() {
        this.locations = new ArrayList<Integer>();
        this.responses = new ArrayList<GetResponse>();
        this.failures = new ArrayList<MultiGetResponse.Failure>();
    }

    public MultiGetShardResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.locations = new ArrayList<Integer>(size);
        this.responses = new ArrayList<GetResponse>(size);
        this.failures = new ArrayList<MultiGetResponse.Failure>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                this.responses.add(new GetResponse(in));
            } else {
                this.responses.add(null);
            }
            if (in.readBoolean()) {
                this.failures.add(new MultiGetResponse.Failure(in));
                continue;
            }
            this.failures.add(null);
        }
    }

    public void add(int location, GetResponse response) {
        this.locations.add(location);
        this.responses.add(response);
        this.failures.add(null);
    }

    public void add(int location, MultiGetResponse.Failure failure) {
        this.locations.add(location);
        this.responses.add(null);
        this.failures.add(failure);
    }

    public List<Integer> getLocations() {
        return this.locations;
    }

    public List<GetResponse> getResponses() {
        return this.responses;
    }

    public List<MultiGetResponse.Failure> getFailures() {
        return this.failures;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            if (this.responses.get(i) == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.responses.get(i).writeTo(out);
            }
            if (this.failures.get(i) == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            this.failures.get(i).writeTo(out);
        }
    }
}

