/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.ingest;

import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.core.action.ingest.SimulateDocumentBaseResult;
import io.skylite.core.action.ingest.SimulateDocumentResult;
import io.skylite.core.action.ingest.SimulateDocumentVerboseResult;
import io.skylite.core.action.ingest.SimulatePipelineRequest;
import io.skylite.core.action.ingest.SimulatePipelineResponse;
import io.skylite.core.action.ingest.SimulateProcessorResult;
import io.skylite.core.ingest.CompoundProcessor;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.Pipeline;
import io.skylite.core.ingest.TrackingResultProcessor;
import io.skylite.core.threadpool.ThreadPool;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public class SimulateExecutionService {
    private static final String THREAD_POOL_NAME = "management";
    private final ThreadPool threadPool;

    public SimulateExecutionService(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    void executeDocument(Pipeline pipeline, IngestDocument ingestDocument, boolean verbose, BiConsumer<SimulateDocumentResult, Exception> handler) {
        if (verbose) {
            CopyOnWriteArrayList<SimulateProcessorResult> processorResultList = new CopyOnWriteArrayList<SimulateProcessorResult>();
            CompoundProcessor verbosePipelineProcessor = TrackingResultProcessor.decorate(pipeline.getCompoundProcessor(), null, processorResultList);
            Pipeline verbosePipeline = new Pipeline(pipeline.getId(), pipeline.getDescription(), pipeline.getVersion(), verbosePipelineProcessor);
            ingestDocument.executePipeline(verbosePipeline, (result, e) -> handler.accept(new SimulateDocumentVerboseResult(processorResultList), (Exception)e));
        } else {
            ingestDocument.executePipeline(pipeline, (result, e) -> {
                if (e == null) {
                    handler.accept(new SimulateDocumentBaseResult((IngestDocument)result), null);
                } else {
                    handler.accept(new SimulateDocumentBaseResult((Exception)e), null);
                }
            });
        }
    }

    public void execute(SimulatePipelineRequest.Parsed request, ActionListener<SimulatePipelineResponse> listener) {
        this.threadPool.executor(THREAD_POOL_NAME).execute((Runnable)ActionRunnable.wrap(listener, l -> {
            AtomicInteger counter = new AtomicInteger();
            CopyOnWriteArrayList<SimulateDocumentResult> responses = new CopyOnWriteArrayList<SimulateDocumentResult>(new SimulateDocumentBaseResult[request.getDocuments().size()]);
            if (request.getDocuments().isEmpty()) {
                l.onResponse((Object)new SimulatePipelineResponse(request.getPipeline().getId(), request.isVerbose(), responses));
                return;
            }
            int iter = 0;
            for (IngestDocument ingestDocument : request.getDocuments()) {
                int index = iter++;
                this.executeDocument(request.getPipeline(), ingestDocument, request.isVerbose(), (response, e) -> {
                    if (response != null) {
                        responses.set(index, (SimulateDocumentResult)response);
                    }
                    if (counter.incrementAndGet() == request.getDocuments().size()) {
                        listener.onResponse((Object)new SimulatePipelineResponse(request.getPipeline().getId(), request.isVerbose(), responses));
                    }
                });
            }
        }));
    }
}

