/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.replication;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class ReplicationTask
extends Task {
    private volatile String phase = "starting";

    public ReplicationTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        super(id, type, action, description, parentTaskId, headers);
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getPhase() {
        return this.phase;
    }

    @Override
    public Status getStatus() {
        return new Status(this.phase);
    }

    public static class Status
    implements Task.Status {
        public static final String NAME = "replication";
        private final String phase;

        public Status(String phase) {
            this.phase = Objects.requireNonNull(phase, "Phase cannot be null");
        }

        public Status(StreamInput in) throws IOException {
            this.phase = in.readString();
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("phase", this.phase);
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.phase);
        }

        public String toString() {
            return Strings.toString(MediaTypeRegistry.JSON, this);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != Status.class) {
                return false;
            }
            Status other = (Status)obj;
            return this.phase.equals(other.phase);
        }

        public int hashCode() {
            return this.phase.hashCode();
        }
    }
}

