/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.common.action.ActionListener;
import io.skylite.common.lease.Releasable;
import io.skylite.core.action.search.AbstractSearchAsyncAction;
import io.skylite.core.action.search.SearchActionListener;
import io.skylite.core.action.search.SearchPhase;
import io.skylite.core.action.search.SearchPhaseContext;
import io.skylite.core.action.search.SearchPhaseName;
import io.skylite.core.action.search.SearchRequestOperationsListener;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchShardIterator;
import io.skylite.core.action.search.SearchTask;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.action.search.TransportSearchAction;
import io.skylite.core.action.search.phase.SearchPhaseResults;
import io.skylite.core.cluster.routing.GroupShardsIterator;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.internal.AliasFilter;
import io.skylite.core.search.sort.FieldSortBuilder;
import io.skylite.core.search.sort.MinAndMax;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.transport.TransportConnection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.FixedBitSet;

final class CanMatchPreFilterSearchPhase
extends AbstractSearchAsyncAction<SearchPhaseResult.CanMatchResponse> {
    private final Function<GroupShardsIterator<SearchShardIterator>, SearchPhase> phaseFactory;
    private final GroupShardsIterator<SearchShardIterator> shardsIts;

    CanMatchPreFilterSearchPhase(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, TransportConnection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, Function<GroupShardsIterator<SearchShardIterator>, SearchPhase> phaseFactory, SearchResponse.Clusters clusters, SearchRequestOperationsListener searchRequestOperationsListener) {
        super(SearchPhaseName.CAN_MATCH.getName(), logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterState, task, new CanMatchSearchPhaseResults(shardsIts.size()), shardsIts.size(), clusters, searchRequestOperationsListener);
        this.phaseFactory = phaseFactory;
        this.shardsIts = shardsIts;
    }

    @Override
    public void addReleasable(Releasable releasable) {
        throw new RuntimeException("cannot add releasable in " + this.getName() + " phase");
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, SearchShardTarget shard, SearchActionListener<SearchPhaseResult.CanMatchResponse> listener) {
        this.getSearchTransport().sendCanMatch(this.getConnection(shard.getClusterAlias(), shard.getNodeId()), this.buildShardSearchRequest(shardIt), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(SearchPhaseResults<SearchPhaseResult.CanMatchResponse> results, SearchPhaseContext context) {
        return this.phaseFactory.apply(this.getIterator((CanMatchSearchPhaseResults)results, this.shardsIts));
    }

    private GroupShardsIterator<SearchShardIterator> getIterator(CanMatchSearchPhaseResults results, GroupShardsIterator<SearchShardIterator> shardsIts) {
        int cardinality = results.getNumPossibleMatches();
        FixedBitSet possibleMatches = results.getPossibleMatches();
        if (cardinality == 0) {
            possibleMatches.set(0);
        }
        SearchSourceBuilder source = this.getRequest().source();
        int i = 0;
        for (SearchShardIterator iter : shardsIts) {
            if (possibleMatches.get(i++)) {
                iter.reset();
                continue;
            }
            iter.resetAndSkip();
        }
        if (!CanMatchPreFilterSearchPhase.shouldSortShards(results.minAndMaxes)) {
            return shardsIts;
        }
        FieldSortBuilder fieldSort = SearchSourceBuilder.getPrimaryFieldSortOrNull(source);
        return new GroupShardsIterator<SearchShardIterator>(CanMatchPreFilterSearchPhase.sortShards(shardsIts, results.minAndMaxes, fieldSort.order()));
    }

    private static List<SearchShardIterator> sortShards(GroupShardsIterator<SearchShardIterator> shardsIts, MinAndMax<?>[] minAndMaxes, SortOrder order) {
        return IntStream.range(0, shardsIts.size()).boxed().sorted(CanMatchPreFilterSearchPhase.shardComparator(shardsIts, minAndMaxes, order)).map(shardsIts::get).collect(Collectors.toList());
    }

    private static boolean shouldSortShards(MinAndMax<?>[] minAndMaxes) {
        Class<?> clazz = null;
        for (MinAndMax<?> minAndMax : minAndMaxes) {
            if (clazz == null) {
                clazz = minAndMax == null ? null : minAndMax.getMin().getClass();
                continue;
            }
            if (minAndMax == null || clazz == minAndMax.getMin().getClass()) continue;
            return false;
        }
        return clazz != null;
    }

    private static Comparator<Integer> shardComparator(GroupShardsIterator<SearchShardIterator> shardsIts, MinAndMax<?>[] minAndMaxes, SortOrder order) {
        Comparator<Integer> comparator = Comparator.comparing(index -> minAndMaxes[index], MinAndMax.getComparator(order));
        return comparator.thenComparing(index -> ((SearchShardIterator)shardsIts.get((int)index)).shardId());
    }

    private static final class CanMatchSearchPhaseResults
    extends SearchPhaseResults<SearchPhaseResult.CanMatchResponse> {
        private final FixedBitSet possibleMatches;
        private final MinAndMax<?>[] minAndMaxes;
        private int numPossibleMatches;

        CanMatchSearchPhaseResults(int size) {
            super(size);
            this.possibleMatches = new FixedBitSet(size);
            this.minAndMaxes = new MinAndMax[size];
        }

        @Override
        public void consumeResult(SearchPhaseResult.CanMatchResponse result, Runnable next) {
            try {
                this.consumeResult(result.getShardIndex(), result.canMatch(), result.estimatedMinAndMax());
            }
            finally {
                next.run();
            }
        }

        @Override
        public boolean hasResult(int shardIndex) {
            return false;
        }

        @Override
        public void consumeShardFailure(int shardIndex) {
            this.consumeResult(shardIndex, true, null);
        }

        synchronized void consumeResult(int shardIndex, boolean canMatch, MinAndMax<?> minAndMax) {
            if (canMatch) {
                this.possibleMatches.set(shardIndex);
                ++this.numPossibleMatches;
            }
            this.minAndMaxes[shardIndex] = minAndMax;
        }

        synchronized int getNumPossibleMatches() {
            return this.numPossibleMatches;
        }

        synchronized FixedBitSet getPossibleMatches() {
            return this.possibleMatches;
        }

        @Override
        public Stream<SearchPhaseResult.CanMatchResponse> getSuccessfulResults() {
            return Stream.empty();
        }
    }
}

