/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.SkyliteException;
import io.skylite.common.CheckedConsumer;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.GroupedActionListener;
import io.skylite.core.action.StepListener;
import io.skylite.core.action.search.CreatePitRequest;
import io.skylite.core.action.search.CreatePitResponse;
import io.skylite.core.action.search.CreateReaderContextRequest;
import io.skylite.core.action.search.DeletePitResponse;
import io.skylite.core.action.search.PitSearchContextIdForNode;
import io.skylite.core.action.search.PitService;
import io.skylite.core.action.search.SearchContextId;
import io.skylite.core.action.search.SearchContextIdForNode;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.action.search.SearchUtils;
import io.skylite.core.action.search.TransportSearchAction;
import io.skylite.core.action.search.UpdatePitContextRequest;
import io.skylite.core.action.search.UpdatePitContextResponse;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class CreatePitController {
    private final SearchTransportService searchTransportService;
    private final ClusterService clusterService;
    private final TransportSearchAction transportSearchAction;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final PitService pitService;
    private static final Logger logger = LogManager.getLogger(CreatePitController.class);
    public static final Setting<TimeValue> PIT_INIT_KEEP_ALIVE = Setting.positiveTimeSetting("point_in_time.init.keep_alive", TimeValue.timeValueSeconds((long)30L), Setting.Property.NodeScope);

    @Inject
    public CreatePitController(SearchTransportService searchTransportService, ClusterService clusterService, TransportSearchAction transportSearchAction, NamedWriteableRegistry namedWriteableRegistry, PitService pitService) {
        this.searchTransportService = searchTransportService;
        this.clusterService = clusterService;
        this.transportSearchAction = transportSearchAction;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.pitService = pitService;
    }

    public void executeCreatePit(CreatePitRequest request, Task task, StepListener<SearchResponse> createPitListener, ActionListener<CreatePitResponse> updatePitIdListener) {
        SearchRequest searchRequest = new SearchRequest(request.getIndices());
        searchRequest.preference(request.getPreference());
        searchRequest.routing(request.getRouting());
        searchRequest.indicesOptions(request.getIndicesOptions());
        searchRequest.allowPartialSearchResults(request.shouldAllowPartialPitCreation());
        Task searchTask = searchRequest.createTask(task.getId(), task.getType(), task.getAction(), task.getParentTaskId(), Collections.emptyMap());
        searchRequest.setCcsMinimizeRoundtrips(false);
        this.executeCreatePit(searchTask, searchRequest, createPitListener);
        createPitListener.whenComplete((CheckedConsumer<SearchResponse, Exception>)((CheckedConsumer)searchResponse -> this.executeUpdatePitId(request, searchRequest, (SearchResponse)searchResponse, updatePitIdListener)), arg_0 -> updatePitIdListener.onFailure(arg_0));
    }

    void executeCreatePit(Task task, SearchRequest searchRequest, StepListener<SearchResponse> createPitListener) {
        logger.debug(() -> new ParameterizedMessage("Executing creation of PIT context for indices [{}]", (Object)Arrays.toString(searchRequest.indices())));
        this.transportSearchAction.executeRequest(task, searchRequest, "create_pit", true, (searchTask, target, connection, searchPhaseResultActionListener) -> this.searchTransportService.createPitContext(connection, new CreateReaderContextRequest(target.getShardId(), PIT_INIT_KEEP_ALIVE.get(this.clusterService.getSettings())), searchTask, ActionListenerHelper.wrap(r -> searchPhaseResultActionListener.onResponse(r), arg_0 -> ((ActionListener)searchPhaseResultActionListener).onFailure(arg_0))), (ActionListener<SearchResponse>)createPitListener);
    }

    void executeUpdatePitId(CreatePitRequest request, SearchRequest searchRequest, SearchResponse searchResponse, ActionListener<CreatePitResponse> updatePitIdListener) {
        logger.debug(() -> new ParameterizedMessage("Updating PIT context with PIT ID [{}], creation time and keep alive", (Object)searchResponse.pointInTimeId()));
        long relativeStartNanos = System.nanoTime();
        TransportSearchAction.SearchTimeProvider timeProvider = new TransportSearchAction.SearchTimeProvider(searchRequest.getOrCreateAbsoluteStartMillis(), relativeStartNanos, System::nanoTime);
        long creationTime = timeProvider.getAbsoluteStartMillis();
        CreatePitResponse createPITResponse = new CreatePitResponse(searchResponse.pointInTimeId(), creationTime, searchResponse.getTotalShards(), searchResponse.getSuccessfulShards(), searchResponse.getSkippedShards(), searchResponse.getFailedShards(), searchResponse.getShardFailures());
        SearchContextId contextId = SearchContextId.decode(this.namedWriteableRegistry, createPITResponse.getId());
        StepListener<BiFunction<String, String, DiscoveryNode>> lookupListener = this.getConnectionLookupListener(contextId);
        lookupListener.whenComplete((CheckedConsumer<BiFunction<String, String, DiscoveryNode>, Exception>)((CheckedConsumer)nodelookup -> {
            ActionListener<UpdatePitContextResponse> groupedActionListener = this.getGroupedListener(updatePitIdListener, createPITResponse, contextId.shards().size(), contextId.shards().values());
            for (Map.Entry<ShardId, SearchContextIdForNode> entry : contextId.shards().entrySet()) {
                DiscoveryNode node = (DiscoveryNode)nodelookup.apply(entry.getValue().getClusterAlias(), entry.getValue().getNode());
                if (node == null) {
                    node = this.clusterService.state().getNodes().get(entry.getValue().getNode());
                }
                if (node == null) {
                    logger.error(() -> new ParameterizedMessage("Create pit update phase for PIT ID [{}] failed because node [{}] not found", (Object)searchResponse.pointInTimeId(), (Object)((SearchContextIdForNode)entry.getValue()).getNode()));
                    groupedActionListener.onFailure((Exception)new SkyliteException("Create pit update phase for PIT ID [" + searchResponse.pointInTimeId() + "] failed because node[" + entry.getValue().getNode() + "] not found", new Object[0]));
                    return;
                }
                try {
                    TransportConnection connection = this.searchTransportService.getConnection(entry.getValue().getClusterAlias(), node);
                    this.searchTransportService.updatePitContext(connection, new UpdatePitContextRequest(entry.getValue().getSearchContextId(), createPITResponse.getId(), request.getKeepAlive().millis(), creationTime), groupedActionListener);
                }
                catch (Exception e) {
                    String nodeName = node.getName();
                    logger.error(() -> new ParameterizedMessage("Create pit update phase failed for PIT ID [{}] on node [{}]", (Object)searchResponse.pointInTimeId(), (Object)nodeName), (Throwable)e);
                    groupedActionListener.onFailure((Exception)new SkyliteException("Create pit update phase for PIT ID [" + searchResponse.pointInTimeId() + "] failed on node[" + String.valueOf(node) + "]", (Throwable)e, new Object[0]));
                }
            }
        }), arg_0 -> updatePitIdListener.onFailure(arg_0));
    }

    private StepListener<BiFunction<String, String, DiscoveryNode>> getConnectionLookupListener(SearchContextId contextId) {
        ClusterState state = this.clusterService.state();
        Set<String> clusters = contextId.shards().values().stream().filter(ctx -> !Strings.isEmpty(ctx.getClusterAlias())).map(SearchContextIdForNode::getClusterAlias).collect(Collectors.toSet());
        return (StepListener)SearchUtils.getConnectionLookupListener(this.searchTransportService.getRemoteClusterService(), state, clusters);
    }

    private ActionListener<UpdatePitContextResponse> getGroupedListener(final ActionListener<CreatePitResponse> updatePitIdListener, final CreatePitResponse createPITResponse, int size, final Collection<SearchContextIdForNode> contexts) {
        return new GroupedActionListener<UpdatePitContextResponse>(new ActionListener<Collection<UpdatePitContextResponse>>(){

            public void onResponse(Collection<UpdatePitContextResponse> responses) {
                updatePitIdListener.onResponse((Object)createPITResponse);
            }

            public void onFailure(Exception e) {
                CreatePitController.this.cleanupContexts(contexts, createPITResponse.getId());
                updatePitIdListener.onFailure(e);
            }
        }, size);
    }

    private void cleanupContexts(Collection<SearchContextIdForNode> contexts, String pitId) {
        ActionListener<DeletePitResponse> deleteListener = new ActionListener<DeletePitResponse>(this){

            public void onResponse(DeletePitResponse response) {
                StringBuilder failedPitsStringBuilder = new StringBuilder();
                response.getDeletePitResults().stream().filter(r -> !r.isSuccessful()).forEach(r -> failedPitsStringBuilder.append(r.getPitId()).append(","));
                logger.warn(() -> new ParameterizedMessage("Failed to delete PIT IDs {}", (Object)failedPitsStringBuilder.toString()));
                if (logger.isDebugEnabled()) {
                    StringBuilder successfulPitsStringBuilder = new StringBuilder();
                    response.getDeletePitResults().stream().filter(r -> r.isSuccessful()).forEach(r -> successfulPitsStringBuilder.append(r.getPitId()).append(","));
                    logger.debug(() -> new ParameterizedMessage("Deleted PIT with IDs {}", (Object)successfulPitsStringBuilder.toString()));
                }
            }

            public void onFailure(Exception e) {
                logger.error("Cleaning up PIT contexts failed ", (Throwable)e);
            }
        };
        HashMap<String, List<PitSearchContextIdForNode>> nodeToContextsMap = new HashMap<String, List<PitSearchContextIdForNode>>();
        for (SearchContextIdForNode context : contexts) {
            List contextIdsForNode = nodeToContextsMap.getOrDefault(context.getNode(), new ArrayList());
            contextIdsForNode.add(new PitSearchContextIdForNode(pitId, context));
            nodeToContextsMap.put(context.getNode(), contextIdsForNode);
        }
        this.pitService.deletePitContexts(nodeToContextsMap, deleteListener);
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(PIT_INIT_KEEP_ALIVE);
        }
    }
}

