/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;

public class CreateReaderContextRequest
extends TransportRequest {
    private final ShardId shardId;
    private final TimeValue keepAlive;

    public CreateReaderContextRequest(ShardId shardId, TimeValue keepAlive) {
        this.shardId = shardId;
        this.keepAlive = keepAlive;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public TimeValue getKeepAlive() {
        return this.keepAlive;
    }

    public CreateReaderContextRequest(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        this.keepAlive = in.readTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        out.writeTimeValue(this.keepAlive);
    }
}

