/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.Nullable;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MultiSearchResponse
extends ActionResponse
implements Iterable<Item>,
ToXContentObject {
    private static final ParseField RESPONSES = new ParseField("responses", new String[0]);
    private static final ParseField TOOK_IN_MILLIS = new ParseField("took", new String[0]);
    private static final ConstructingObjectParser<MultiSearchResponse, Void> PARSER = new ConstructingObjectParser("multi_search", true, a -> new MultiSearchResponse(((List)a[0]).toArray(new Item[0]), (Long)a[1]));
    private final Item[] items;
    private final long tookInMillis;

    public MultiSearchResponse(StreamInput in) throws IOException {
        super(in);
        this.items = new Item[in.readVInt()];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new Item(in);
        }
        this.tookInMillis = in.readVLong();
    }

    public MultiSearchResponse(Item[] items, long tookInMillis) {
        this.items = items;
        this.tookInMillis = tookInMillis;
    }

    @Override
    public Iterator<Item> iterator() {
        return Arrays.stream(this.items).iterator();
    }

    public Item[] getResponses() {
        return this.items;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.items.length);
        for (Item item : this.items) {
            item.writeTo(out);
        }
        out.writeVLong(this.tookInMillis);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("took", this.tookInMillis);
        builder.startArray("responses");
        for (Item item : this.items) {
            builder.startObject();
            if (item.isFailure()) {
                SkyliteException.generateFailureXContent(builder, params, item.getFailure(), true);
                builder.field("status", SkyliteExceptionsHelper.status(item.getFailure()).getStatus());
            } else {
                item.getResponse().innerToXContent(builder, params);
                builder.field("status", item.getResponse().status().getStatus());
            }
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static MultiSearchResponse fromXContext(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Item itemFromXContent(XContentParser parser) throws IOException {
        Item item = null;
        String fieldName = null;
        XContentParser.Token token = parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        block4: while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    fieldName = parser.currentName();
                    if ("error".equals(fieldName)) {
                        item = new Item(null, SkyliteException.failureFromXContent(parser));
                        break;
                    }
                    if ("status".equals(fieldName)) break;
                    item = new Item(SearchResponse.innerFromXContent(parser), null);
                    break block4;
                }
                case VALUE_NUMBER: {
                    if (!"status".equals(fieldName)) break;
                }
            }
            token = parser.nextToken();
        }
        assert (parser.currentToken() == XContentParser.Token.END_OBJECT);
        return item;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> MultiSearchResponse.itemFromXContent(p), RESPONSES);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOOK_IN_MILLIS);
    }

    public static class Item
    implements Writeable {
        private final SearchResponse response;
        private final Exception exception;

        public Item(SearchResponse response, Exception exception) {
            this.response = response;
            this.exception = exception;
        }

        Item(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new SearchResponse(in);
                this.exception = null;
            } else {
                this.exception = in.readException();
                this.response = null;
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.response != null) {
                out.writeBoolean(true);
                this.response.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeException(this.exception);
            }
        }

        public boolean isFailure() {
            return this.exception != null;
        }

        @Nullable
        public String getFailureMessage() {
            return this.exception == null ? null : this.exception.getMessage();
        }

        @Nullable
        public SearchResponse getResponse() {
            return this.response;
        }

        public Exception getFailure() {
            return this.exception;
        }
    }

    static final class Fields {
        static final String RESPONSES = "responses";
        static final String STATUS = "status";

        Fields() {
        }
    }
}

