/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.GroupedActionListener;
import io.skylite.core.action.StepListener;
import io.skylite.core.action.search.DeletePitInfo;
import io.skylite.core.action.search.DeletePitResponse;
import io.skylite.core.action.search.GetAllPitNodesRequest;
import io.skylite.core.action.search.GetAllPitNodesResponse;
import io.skylite.core.action.search.PitSearchContextIdForNode;
import io.skylite.core.action.search.SearchContextId;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.action.search.SearchUtils;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.transport.TransportConnection;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class PitService {
    private static final Logger logger = LogManager.getLogger(PitService.class);
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final TransportService transportService;
    private final NodeClient nodeClient;

    @Inject
    public PitService(ClusterService clusterService, SearchTransportService searchTransportService, TransportService transportService, NodeClient nodeClient) {
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
        this.transportService = transportService;
        this.nodeClient = nodeClient;
    }

    public void deletePitContexts(Map<String, List<PitSearchContextIdForNode>> nodeToContextsMap, ActionListener<DeletePitResponse> listener) {
        if (nodeToContextsMap.size() == 0) {
            listener.onResponse((Object)new DeletePitResponse(Collections.emptyList()));
            return;
        }
        Set<String> clusters = nodeToContextsMap.values().stream().flatMap(Collection::stream).filter(ctx -> !Strings.isEmpty(ctx.getSearchContextIdForNode().getClusterAlias())).map(c -> c.getSearchContextIdForNode().getClusterAlias()).collect(Collectors.toSet());
        StepListener lookupListener = (StepListener)SearchUtils.getConnectionLookupListener(this.searchTransportService.getRemoteClusterService(), this.clusterService.state(), clusters);
        lookupListener.whenComplete(nodeLookup -> {
            GroupedActionListener<DeletePitResponse> groupedListener = this.getDeletePitGroupedListener(listener, nodeToContextsMap.size());
            for (Map.Entry entry : nodeToContextsMap.entrySet()) {
                String clusterAlias = ((PitSearchContextIdForNode)((List)entry.getValue()).get(0)).getSearchContextIdForNode().getClusterAlias();
                DiscoveryNode node = (DiscoveryNode)nodeLookup.apply(clusterAlias, ((PitSearchContextIdForNode)((List)entry.getValue()).get(0)).getSearchContextIdForNode().getNode());
                if (node == null) {
                    node = this.clusterService.state().getNodes().get(((PitSearchContextIdForNode)((List)entry.getValue()).get(0)).getSearchContextIdForNode().getNode());
                }
                if (node == null) {
                    logger.error(() -> new ParameterizedMessage("node [{}] not found", (Object)((PitSearchContextIdForNode)((List)entry.getValue()).get(0)).getSearchContextIdForNode().getNode()));
                    ArrayList<DeletePitInfo> deletePitInfos = new ArrayList<DeletePitInfo>();
                    for (PitSearchContextIdForNode pitSearchContextIdForNode : (List)entry.getValue()) {
                        deletePitInfos.add(new DeletePitInfo(false, pitSearchContextIdForNode.getPitId()));
                    }
                    groupedListener.onResponse(new DeletePitResponse(deletePitInfos));
                    continue;
                }
                try {
                    TransportConnection connection = this.searchTransportService.getConnection(clusterAlias, node);
                    this.searchTransportService.sendFreePITContexts(connection, (List)entry.getValue(), groupedListener);
                }
                catch (Exception e) {
                    String nodeName = node.getName();
                    logger.error(() -> new ParameterizedMessage("Delete PITs failed on node [{}]", (Object)nodeName), (Throwable)e);
                    ArrayList<DeletePitInfo> deletePitInfos = new ArrayList<DeletePitInfo>();
                    for (PitSearchContextIdForNode pitSearchContextIdForNode : (List)entry.getValue()) {
                        deletePitInfos.add(new DeletePitInfo(false, pitSearchContextIdForNode.getPitId()));
                    }
                    groupedListener.onResponse(new DeletePitResponse(deletePitInfos));
                }
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public GroupedActionListener<DeletePitResponse> getDeletePitGroupedListener(final ActionListener<DeletePitResponse> listener, int size) {
        return new GroupedActionListener<DeletePitResponse>(new ActionListener<Collection<DeletePitResponse>>(this){

            public void onResponse(Collection<DeletePitResponse> responses) {
                HashMap<String, Boolean> pitIdToSucceededMap = new HashMap<String, Boolean>();
                for (DeletePitResponse deletePitResponse : responses) {
                    for (DeletePitInfo deletePitInfo : deletePitResponse.getDeletePitResults()) {
                        if (!pitIdToSucceededMap.containsKey(deletePitInfo.getPitId())) {
                            pitIdToSucceededMap.put(deletePitInfo.getPitId(), deletePitInfo.isSuccessful());
                        }
                        if (deletePitInfo.isSuccessful()) continue;
                        logger.debug(() -> new ParameterizedMessage("Deleting PIT with ID {} failed ", (Object)deletePitInfo.getPitId()));
                        pitIdToSucceededMap.put(deletePitInfo.getPitId(), deletePitInfo.isSuccessful());
                    }
                }
                ArrayList<DeletePitInfo> deletePitResults = new ArrayList<DeletePitInfo>();
                for (Map.Entry entry : pitIdToSucceededMap.entrySet()) {
                    deletePitResults.add(new DeletePitInfo((Boolean)entry.getValue(), (String)entry.getKey()));
                }
                DeletePitResponse deletePitResponse = new DeletePitResponse(deletePitResults);
                listener.onResponse((Object)deletePitResponse);
            }

            public void onFailure(Exception e) {
                logger.error("Delete PITs failed", (Throwable)e);
                listener.onFailure(e);
            }
        }, size);
    }

    public Map<String, String[]> getIndicesForPits(List<String> pitIds) {
        HashMap<String, String[]> pitToIndicesMap = new HashMap<String, String[]>();
        for (String pitId : pitIds) {
            pitToIndicesMap.put(pitId, SearchContextId.decode(this.nodeClient.getNamedWriteableRegistry(), pitId).getActualIndices());
        }
        return pitToIndicesMap;
    }

    public void getAllPits(final ActionListener<GetAllPitNodesResponse> getAllPitsListener) {
        ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : this.clusterService.state().nodes().getDataNodes().values()) {
            nodes.add(node);
        }
        DiscoveryNode[] disNodesArr = nodes.toArray(new DiscoveryNode[0]);
        GetAllPitNodesRequest getAllPitNodesRequest = new GetAllPitNodesRequest(disNodesArr);
        this.transportService.sendRequest(this.transportService.getLocalNode(), "indices:data/read/point_in_time/readall", getAllPitNodesRequest, new TransportResponseHandler<GetAllPitNodesResponse>(){

            @Override
            public void handleResponse(GetAllPitNodesResponse response) {
                getAllPitsListener.onResponse((Object)response);
            }

            @Override
            public void handleException(TransportException exp) {
                getAllPitsListener.onFailure((Exception)exp);
            }

            @Override
            public String executor() {
                return "same";
            }

            @Override
            public GetAllPitNodesResponse read(StreamInput in) throws IOException {
                return new GetAllPitNodesResponse(in);
            }
        });
    }
}

