/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.common.Nullable;
import io.skylite.common.lease.Releasable;
import io.skylite.core.action.OriginalIndices;
import io.skylite.core.action.search.SearchPhase;
import io.skylite.core.action.search.SearchShardIterator;
import io.skylite.core.action.search.SearchTask;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.common.concurrent.AtomicArray;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.internal.InternalSearchResponse;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.transport.TransportConnection;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.Logger;

public interface SearchPhaseContext
extends Executor {
    public int getNumShards();

    public Logger getLogger();

    public SearchTask getTask();

    public SearchRequest getRequest();

    public SearchPhase getCurrentPhase();

    public void sendSearchResponse(InternalSearchResponse var1, AtomicArray<SearchPhaseResult> var2);

    public void onFailure(Exception var1);

    public void onPhaseFailure(SearchPhase var1, String var2, Throwable var3);

    public void onShardFailure(int var1, @Nullable SearchShardTarget var2, Exception var3);

    public TransportConnection getConnection(String var1, String var2);

    public SearchTransportService getSearchTransport();

    default public void sendReleaseSearchContext(ShardSearchContextId contextId, TransportConnection connection, OriginalIndices originalIndices) {
        if (connection != null) {
            this.getSearchTransport().sendFreeContext(connection, contextId, originalIndices);
        }
    }

    public ShardSearchRequest buildShardSearchRequest(SearchShardIterator var1);

    public void executeNextPhase(SearchPhase var1, SearchPhase var2);

    public void addReleasable(Releasable var1);
}

