/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchShard;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.search.SearchShardTarget;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.search.TotalHits;

public abstract class SearchProgressListener {
    private static final Logger logger = LogManager.getLogger(SearchProgressListener.class);
    public static final SearchProgressListener NOOP = new SearchProgressListener(){};
    private List<SearchShard> shards;

    protected void onListShards(List<SearchShard> shards, List<SearchShard> skippedShards, SearchResponse.Clusters clusters, boolean fetchPhase) {
    }

    protected void onQueryResult(int shardIndex) {
    }

    protected void onQueryFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
    }

    protected void onPartialReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int reducePhase) {
    }

    protected void onFinalReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int reducePhase) {
    }

    protected void onFetchResult(int shardIndex) {
    }

    protected void onFetchFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
    }

    public final void notifyListShards(List<SearchShard> shards, List<SearchShard> skippedShards, SearchResponse.Clusters clusters, boolean fetchPhase) {
        this.shards = shards;
        try {
            this.onListShards(shards, skippedShards, clusters, fetchPhase);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("Failed to execute progress listener on list shards", new Object[0]), (Throwable)e);
        }
    }

    public final void notifyQueryResult(int shardIndex) {
        try {
            this.onQueryResult(shardIndex);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] Failed to execute progress listener on query result", (Object)this.shards.get(shardIndex)), (Throwable)e);
        }
    }

    public final void notifyQueryFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
        try {
            this.onQueryFailure(shardIndex, shardTarget, exc);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] Failed to execute progress listener on query failure", (Object)this.shards.get(shardIndex)), (Throwable)e);
        }
    }

    public final void notifyPartialReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int reducePhase) {
        try {
            this.onPartialReduce(shards, totalHits, aggs, reducePhase);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("Failed to execute progress listener on partial reduce", new Object[0]), (Throwable)e);
        }
    }

    public final void notifyFinalReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int reducePhase) {
        try {
            this.onFinalReduce(shards, totalHits, aggs, reducePhase);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("Failed to execute progress listener on reduce", new Object[0]), (Throwable)e);
        }
    }

    public final void notifyFetchResult(int shardIndex) {
        try {
            this.onFetchResult(shardIndex);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] Failed to execute progress listener on fetch result", (Object)this.shards.get(shardIndex)), (Throwable)e);
        }
    }

    public final void notifyFetchFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
        try {
            this.onFetchFailure(shardIndex, shardTarget, exc);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] Failed to execute progress listener on fetch failure", (Object)this.shards.get(shardIndex)), (Throwable)e);
        }
    }
}

