/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.core.action.search.SearchQueryCategorizingVisitor;
import io.skylite.core.action.search.SearchQueryCounters;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryShapeVisitor;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.SortBuilder;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.core.telemetry.metrics.tags.Tags;
import java.util.List;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class SearchQueryCategorizer {
    private static final Logger log = LogManager.getLogger(SearchQueryCategorizer.class);
    final SearchQueryCounters searchQueryCounters;

    public SearchQueryCategorizer(MetricsRegistry metricsRegistry) {
        this.searchQueryCounters = new SearchQueryCounters(metricsRegistry);
    }

    public void categorize(SearchSourceBuilder source) {
        QueryBuilder topLevelQueryBuilder = source.query();
        this.logQueryShape(topLevelQueryBuilder);
        this.incrementQueryTypeCounters(topLevelQueryBuilder);
        this.incrementQueryAggregationCounters(source.aggregations());
        this.incrementQuerySortCounters(source.sorts());
    }

    private void incrementQuerySortCounters(List<SortBuilder<?>> sorts) {
        if (sorts != null && sorts.size() > 0) {
            ListIterator<SortBuilder<?>> it = sorts.listIterator();
            while (it.hasNext()) {
                SortBuilder<?> sortBuilder = it.next();
                String sortOrder = sortBuilder.order().toString();
                this.searchQueryCounters.sortCounter.add(1.0, Tags.create().addTag("sort_order", sortOrder));
            }
        }
    }

    private void incrementQueryAggregationCounters(AggregatorFactories.Builder aggregations) {
        if (aggregations != null) {
            this.searchQueryCounters.aggCounter.add(1.0);
        }
    }

    private void incrementQueryTypeCounters(QueryBuilder topLevelQueryBuilder) {
        if (topLevelQueryBuilder == null) {
            return;
        }
        SearchQueryCategorizingVisitor searchQueryVisitor = new SearchQueryCategorizingVisitor(this.searchQueryCounters);
        topLevelQueryBuilder.visit(searchQueryVisitor);
    }

    private void logQueryShape(QueryBuilder topLevelQueryBuilder) {
        if (topLevelQueryBuilder == null) {
            return;
        }
        QueryShapeVisitor shapeVisitor = new QueryShapeVisitor();
        topLevelQueryBuilder.visit(shapeVisitor);
        log.debug("Query shape : {}", (Object)shapeVisitor.prettyPrintTree("  "));
    }
}

