/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.search.AbstractSearchAsyncAction;
import io.skylite.core.action.search.BottomSortValuesCollector;
import io.skylite.core.action.search.SearchActionListener;
import io.skylite.core.action.search.SearchPhase;
import io.skylite.core.action.search.SearchPhaseContext;
import io.skylite.core.action.search.SearchPhaseName;
import io.skylite.core.action.search.SearchProgressListener;
import io.skylite.core.action.search.SearchRequestOperationsListener;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchShard;
import io.skylite.core.action.search.SearchShardIterator;
import io.skylite.core.action.search.SearchTask;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.action.search.TransportSearchAction;
import io.skylite.core.action.search.phase.FetchSearchPhase;
import io.skylite.core.action.search.phase.QueryPhaseResultConsumer;
import io.skylite.core.action.search.phase.SearchPhaseController;
import io.skylite.core.action.search.phase.SearchPhaseResults;
import io.skylite.core.cluster.routing.GroupShardsIterator;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.internal.AliasFilter;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.transport.TransportConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TopFieldDocs;

class SearchQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<SearchPhaseResult> {
    private final SearchPhaseController searchPhaseController;
    private final SearchProgressListener progressListener;
    private final int topDocsSize;
    private final int trackTotalHitsUpTo;
    private volatile BottomSortValuesCollector bottomSortCollector;

    SearchQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, TransportConnection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, SearchPhaseController searchPhaseController, Executor executor, QueryPhaseResultConsumer resultConsumer, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, SearchResponse.Clusters clusters, SearchRequestOperationsListener searchRequestOperationsListener) {
        super(SearchPhaseName.QUERY.getName(), logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterState, task, resultConsumer, request.getMaxConcurrentShardRequests(), clusters, searchRequestOperationsListener);
        this.topDocsSize = SearchPhaseController.getTopDocsSize(request);
        this.trackTotalHitsUpTo = request.resolveTrackTotalHitsUpTo();
        this.searchPhaseController = searchPhaseController;
        this.progressListener = task.getProgressListener();
        this.addReleasable(resultConsumer);
        boolean hasFetchPhase = request.source() == null ? true : request.source().size() > 0;
        this.progressListener.notifyListShards(SearchQueryThenFetchAsyncAction.buildSearchShards(this.shardsIts), SearchQueryThenFetchAsyncAction.buildSearchShards(this.toSkipShardsIts), clusters, hasFetchPhase);
    }

    public static List<SearchShard> buildSearchShards(GroupShardsIterator<SearchShardIterator> its) {
        List lst = StreamSupport.stream(its.spliterator(), false).map(e -> new SearchShard(e.getClusterAlias(), e.shardId())).collect(Collectors.toList());
        return Collections.unmodifiableList(lst);
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, SearchShardTarget shard, SearchActionListener<SearchPhaseResult> listener) {
        ShardSearchRequest request = this.rewriteShardSearchRequest(super.buildShardSearchRequest(shardIt));
        if (request != null) {
            request.setInboundNetworkTime(System.currentTimeMillis());
        }
        this.getSearchTransport().sendExecuteQuery(this.getConnection(shard.getClusterAlias(), shard.getNodeId()), request, this.getTask(), listener);
    }

    @Override
    protected void onShardGroupFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
        this.progressListener.notifyQueryFailure(shardIndex, shardTarget, exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onShardResult(SearchPhaseResult result, SearchShardIterator shardIt) {
        QuerySearchResult queryResult = result.queryResult();
        if (!queryResult.isNull() && this.getRequest().scroll() == null && queryResult.topDocs() != null && queryResult.topDocs().topDocs.getClass() == TopFieldDocs.class) {
            TopFieldDocs topDocs = (TopFieldDocs)queryResult.topDocs().topDocs;
            if (this.bottomSortCollector == null) {
                SearchQueryThenFetchAsyncAction searchQueryThenFetchAsyncAction = this;
                synchronized (searchQueryThenFetchAsyncAction) {
                    if (this.bottomSortCollector == null) {
                        this.bottomSortCollector = new BottomSortValuesCollector(this.topDocsSize, topDocs.fields);
                    }
                }
            }
            this.bottomSortCollector.consumeTopDocs(topDocs, queryResult.sortValueFormats());
        }
        super.onShardResult(result, shardIt);
    }

    @Override
    protected SearchPhase getNextPhase(SearchPhaseResults<SearchPhaseResult> results, SearchPhaseContext context) {
        return new FetchSearchPhase(results, this.searchPhaseController, null, this);
    }

    private ShardSearchRequest rewriteShardSearchRequest(ShardSearchRequest request) {
        if (this.bottomSortCollector == null) {
            return request;
        }
        if (this.trackTotalHitsUpTo != Integer.MAX_VALUE && this.bottomSortCollector.getTotalHits() > (long)this.trackTotalHitsUpTo) {
            request.source(request.source().shallowCopy().trackTotalHits(false));
        }
        if (this.bottomSortCollector.getBottomSortValues() != null) {
            request.setBottomSortValues(this.bottomSortCollector.getBottomSortValues());
        }
        return request;
    }
}

