/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.common.metrics.CounterMetric;
import io.skylite.common.metrics.MeanMetric;
import io.skylite.core.action.search.SearchPhaseContext;
import io.skylite.core.action.search.SearchPhaseName;
import io.skylite.core.action.search.SearchRequestOperationsListener;
import io.skylite.core.common.inject.Inject;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class SearchRequestStats
implements SearchRequestOperationsListener {
    Map<SearchPhaseName, StatsHolder> phaseStatsMap = new EnumMap<SearchPhaseName, StatsHolder>(SearchPhaseName.class);

    @Inject
    public SearchRequestStats() {
        for (SearchPhaseName searchPhaseName : SearchPhaseName.values()) {
            this.phaseStatsMap.put(searchPhaseName, new StatsHolder());
        }
    }

    public long getPhaseCurrent(SearchPhaseName searchPhaseName) {
        return this.phaseStatsMap.get((Object)((Object)searchPhaseName)).current.count();
    }

    public long getPhaseTotal(SearchPhaseName searchPhaseName) {
        return this.phaseStatsMap.get((Object)((Object)searchPhaseName)).total.count();
    }

    public long getPhaseMetric(SearchPhaseName searchPhaseName) {
        return this.phaseStatsMap.get((Object)((Object)searchPhaseName)).timing.sum();
    }

    @Override
    public void onPhaseStart(SearchPhaseContext context) {
        this.phaseStatsMap.get((Object)((Object)context.getCurrentPhase().getSearchPhaseName())).current.inc();
    }

    @Override
    public void onPhaseEnd(SearchPhaseContext context) {
        StatsHolder phaseStats = this.phaseStatsMap.get((Object)context.getCurrentPhase().getSearchPhaseName());
        phaseStats.current.dec();
        phaseStats.total.inc();
        phaseStats.timing.inc(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - context.getCurrentPhase().getStartTimeInNanos()));
    }

    @Override
    public void onPhaseFailure(SearchPhaseContext context) {
        this.phaseStatsMap.get((Object)((Object)context.getCurrentPhase().getSearchPhaseName())).current.dec();
    }

    public static final class StatsHolder {
        CounterMetric current = new CounterMetric();
        CounterMetric total = new CounterMetric();
        MeanMetric timing = new MeanMetric();
    }
}

