/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionListenerResponseHandler;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.OriginalIndices;
import io.skylite.core.action.search.CreateReaderContextRequest;
import io.skylite.core.action.search.CreateReaderContextResponse;
import io.skylite.core.action.search.DeletePitResponse;
import io.skylite.core.action.search.MultiSearchRequest;
import io.skylite.core.action.search.MultiSearchResponse;
import io.skylite.core.action.search.PitSearchContextIdForNode;
import io.skylite.core.action.search.SearchActionListener;
import io.skylite.core.action.search.SearchShardTask;
import io.skylite.core.action.search.SearchTask;
import io.skylite.core.action.search.UpdatePitContextRequest;
import io.skylite.core.action.search.UpdatePitContextResponse;
import io.skylite.core.action.search.query.QuerySearchRequest;
import io.skylite.core.action.search.query.ScrollQuerySearchResult;
import io.skylite.core.action.support.ChannelActionListener;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.search.BaseSearchService;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.dfs.DfsSearchResult;
import io.skylite.core.search.fetch.FetchSearchResult;
import io.skylite.core.search.fetch.QueryFetchSearchResult;
import io.skylite.core.search.fetch.ScrollQueryFetchSearchResult;
import io.skylite.core.search.fetch.ShardFetchRequest;
import io.skylite.core.search.fetch.ShardFetchSearchRequest;
import io.skylite.core.search.internal.InternalScrollSearchRequest;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.RemoteClusterService;
import io.skylite.core.transport.TransportActionProxy;
import io.skylite.core.transport.TransportConnection;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public class SearchTransportService {
    public static final String FREE_CONTEXT_SCROLL_ACTION_NAME = "indices:data/read/search[free_context/scroll]";
    public static final String FREE_CONTEXT_ACTION_NAME = "indices:data/read/search[free_context]";
    public static final String CLEAR_SCROLL_CONTEXTS_ACTION_NAME = "indices:data/read/search[clear_scroll_contexts]";
    public static final String FREE_PIT_CONTEXT_ACTION_NAME = "indices:data/read/search[free_context/pit]";
    public static final String FREE_ALL_PIT_CONTEXTS_ACTION_NAME = "indices:data/read/search[free_pit_contexts]";
    public static final String DFS_ACTION_NAME = "indices:data/read/search[phase/dfs]";
    public static final String QUERY_ACTION_NAME = "indices:data/read/search[phase/query]";
    public static final String QUERY_ID_ACTION_NAME = "indices:data/read/search[phase/query/id]";
    public static final String QUERY_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query/scroll]";
    public static final String QUERY_FETCH_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query+fetch/scroll]";
    public static final String FETCH_ID_SCROLL_ACTION_NAME = "indices:data/read/search[phase/fetch/id/scroll]";
    public static final String FETCH_ID_ACTION_NAME = "indices:data/read/search[phase/fetch/id]";
    public static final String QUERY_CAN_MATCH_NAME = "indices:data/read/search[can_match]";
    public static final String CREATE_READER_CONTEXT_ACTION_NAME = "indices:data/read/search[create_context]";
    public static final String UPDATE_READER_CONTEXT_ACTION_NAME = "indices:data/read/search[update_context]";
    private final TransportService transportService;
    private final BiFunction<TransportConnection, SearchActionListener, ActionListener> responseWrapper;
    private final Map<String, Long> clientConnections = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();

    public SearchTransportService(TransportService transportService, BiFunction<TransportConnection, SearchActionListener, ActionListener> responseWrapper) {
        this.transportService = transportService;
        this.responseWrapper = responseWrapper;
    }

    public void sendFreeContext(TransportConnection connection, ShardSearchContextId contextId, OriginalIndices originalIndices) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_ACTION_NAME, (TransportRequest)new SearchFreeContextRequest(originalIndices, contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(new ActionListener<SearchFreeContextResponse>(this){

            public void onResponse(SearchFreeContextResponse response) {
            }

            public void onFailure(Exception e) {
            }
        }, SearchFreeContextResponse::new));
    }

    public void sendFreeContext(TransportConnection connection, ShardSearchContextId contextId, ActionListener<SearchFreeContextResponse> listener) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_SCROLL_ACTION_NAME, (TransportRequest)new ScrollFreeContextRequest(contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(listener, SearchFreeContextResponse::new));
    }

    public void updatePitContext(TransportConnection connection, UpdatePitContextRequest request, ActionListener<UpdatePitContextResponse> actionListener) {
        this.transportService.sendRequest(connection, UPDATE_READER_CONTEXT_ACTION_NAME, (TransportRequest)request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<UpdatePitContextResponse>(actionListener, UpdatePitContextResponse::new));
    }

    public void createPitContext(TransportConnection connection, CreateReaderContextRequest request, SearchTask task, ActionListener<CreateReaderContextResponse> actionListener) {
        this.transportService.sendChildRequest(connection, CREATE_READER_CONTEXT_ACTION_NAME, (TransportRequest)request, (Task)task, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<CreateReaderContextResponse>(actionListener, CreateReaderContextResponse::new));
    }

    public void sendCanMatch(TransportConnection connection, ShardSearchRequest request, SearchTask task, ActionListener<SearchPhaseResult.CanMatchResponse> listener) {
        this.transportService.sendChildRequest(connection, QUERY_CAN_MATCH_NAME, (TransportRequest)request, (Task)task, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchPhaseResult.CanMatchResponse>(listener, SearchPhaseResult.CanMatchResponse::new));
    }

    public void sendClearAllScrollContexts(TransportConnection connection, ActionListener<TransportResponse> listener) {
        this.transportService.sendRequest(connection, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, (TransportRequest)TransportRequest.Empty.INSTANCE, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse.Empty>(listener, in -> TransportResponse.Empty.INSTANCE));
    }

    public void sendFreePITContexts(TransportConnection connection, List<PitSearchContextIdForNode> contextIds, ActionListener<DeletePitResponse> listener) {
        this.transportService.sendRequest(connection, FREE_PIT_CONTEXT_ACTION_NAME, (TransportRequest)new PitFreeContextsRequest(contextIds), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<DeletePitResponse>(listener, DeletePitResponse::new));
    }

    public void sendExecuteDfs(TransportConnection connection, ShardSearchRequest request, SearchTask task, SearchActionListener<DfsSearchResult> listener) {
        this.transportService.sendChildRequest(connection, DFS_ACTION_NAME, request, task, new ConnectionCountingHandler<DfsSearchResult>(this, listener, DfsSearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteQuery(TransportConnection connection, ShardSearchRequest request, SearchTask task, SearchActionListener<SearchPhaseResult> listener) {
        boolean fetchDocuments = request.numberOfShards() == 1;
        Writeable.Reader<SearchPhaseResult> reader = fetchDocuments ? QueryFetchSearchResult::new : QuerySearchResult::new;
        ActionListener handler = this.responseWrapper.apply(connection, listener);
        this.transportService.sendChildRequest(connection, QUERY_ACTION_NAME, request, task, new ConnectionCountingHandler<SearchPhaseResult>(this, handler, reader, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteQuery(TransportConnection connection, QuerySearchRequest request, SearchTask task, SearchActionListener<QuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_ID_ACTION_NAME, request, task, new ConnectionCountingHandler<QuerySearchResult>(this, listener, QuerySearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteScrollQuery(TransportConnection connection, InternalScrollSearchRequest request, SearchTask task, SearchActionListener<ScrollQuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_SCROLL_ACTION_NAME, request, task, new ConnectionCountingHandler<ScrollQuerySearchResult>(this, listener, ScrollQuerySearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteScrollFetch(TransportConnection connection, InternalScrollSearchRequest request, SearchTask task, SearchActionListener<ScrollQueryFetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_FETCH_SCROLL_ACTION_NAME, request, task, new ConnectionCountingHandler<ScrollQueryFetchSearchResult>(this, listener, ScrollQueryFetchSearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteFetch(TransportConnection connection, ShardFetchSearchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_ACTION_NAME, request, task, listener);
    }

    public void sendExecuteFetchScroll(TransportConnection connection, ShardFetchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_SCROLL_ACTION_NAME, request, task, listener);
    }

    private void sendExecuteFetch(TransportConnection connection, String action, ShardFetchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, action, request, task, new ConnectionCountingHandler<FetchSearchResult>(this, listener, FetchSearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteMultiSearch(MultiSearchRequest request, SearchTask task, ActionListener<MultiSearchResponse> listener) {
        TransportConnection connection = this.transportService.getConnection(this.transportService.getLocalNode());
        this.transportService.sendChildRequest(connection, "indices:data/read/msearch", request, task, new ConnectionCountingHandler<MultiSearchResponse>(this, listener, MultiSearchResponse::new, this.clientConnections, connection.getNode().getId()));
    }

    public RemoteClusterService getRemoteClusterService() {
        return this.transportService.getRemoteClusterService();
    }

    public Map<String, Long> getPendingSearchRequests() {
        return new HashMap<String, Long>(this.clientConnections);
    }

    public static void registerRequestHandler(TransportService transportService, BaseSearchService searchService) {
        transportService.registerRequestHandler(FREE_CONTEXT_SCROLL_ACTION_NAME, "same", ScrollFreeContextRequest::new, (request, channel, task) -> {
            boolean freed = searchService.freeReaderContext(request.id());
            channel.sendResponse(new SearchFreeContextResponse(freed));
        });
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_SCROLL_ACTION_NAME, SearchFreeContextResponse::new);
        transportService.registerRequestHandler(FREE_PIT_CONTEXT_ACTION_NAME, "same", PitFreeContextsRequest::new, (request, channel, task) -> channel.sendResponse(searchService.freeReaderContextsIfFound(request.getContextIds())));
        TransportActionProxy.registerProxyAction(transportService, FREE_PIT_CONTEXT_ACTION_NAME, DeletePitResponse::new);
        transportService.registerRequestHandler(FREE_CONTEXT_ACTION_NAME, "same", SearchFreeContextRequest::new, (request, channel, task) -> {
            boolean freed = searchService.freeReaderContext(request.id());
            channel.sendResponse(new SearchFreeContextResponse(freed));
        });
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_ACTION_NAME, SearchFreeContextResponse::new);
        transportService.registerRequestHandler(CLEAR_SCROLL_CONTEXTS_ACTION_NAME, "same", TransportRequest.Empty::new, (request, channel, task) -> {
            searchService.freeAllScrollContexts();
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        });
        TransportActionProxy.registerProxyAction(transportService, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, in -> TransportResponse.Empty.INSTANCE);
        transportService.registerRequestHandler(DFS_ACTION_NAME, "same", ShardSearchRequest::new, (request, channel, task) -> searchService.executeDfsPhase((ShardSearchRequest)request, false, (SearchShardTask)task, new ChannelActionListener(channel, DFS_ACTION_NAME, (ShardSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, DFS_ACTION_NAME, DfsSearchResult::new);
        transportService.registerRequestHandler(QUERY_ACTION_NAME, "same", ShardSearchRequest::new, (request, channel, task) -> searchService.executeQueryPhase((ShardSearchRequest)request, false, (SearchShardTask)task, new ChannelActionListener(channel, QUERY_ACTION_NAME, (ShardSearchRequest)request)));
        TransportActionProxy.registerProxyActionWithDynamicResponseType(transportService, QUERY_ACTION_NAME, request -> ((ShardSearchRequest)request).numberOfShards() == 1 ? QueryFetchSearchResult::new : QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_ID_ACTION_NAME, "same", QuerySearchRequest::new, (request, channel, task) -> searchService.executeQueryPhase((QuerySearchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, QUERY_ID_ACTION_NAME, (QuerySearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_ID_ACTION_NAME, QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_SCROLL_ACTION_NAME, "same", InternalScrollSearchRequest::new, (request, channel, task) -> searchService.executeQueryPhase((InternalScrollSearchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, QUERY_SCROLL_ACTION_NAME, (InternalScrollSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_SCROLL_ACTION_NAME, ScrollQuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_FETCH_SCROLL_ACTION_NAME, "same", InternalScrollSearchRequest::new, (request, channel, task) -> searchService.executeFetchPhase((InternalScrollSearchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, QUERY_FETCH_SCROLL_ACTION_NAME, (InternalScrollSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_FETCH_SCROLL_ACTION_NAME, ScrollQueryFetchSearchResult::new);
        transportService.registerRequestHandler(FETCH_ID_SCROLL_ACTION_NAME, "same", ShardFetchRequest::new, (request, channel, task) -> searchService.executeFetchPhase((ShardFetchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, FETCH_ID_SCROLL_ACTION_NAME, (ShardFetchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_SCROLL_ACTION_NAME, FetchSearchResult::new);
        transportService.registerRequestHandler(FETCH_ID_ACTION_NAME, "same", true, true, ShardFetchSearchRequest::new, (request, channel, task) -> searchService.executeFetchPhase((ShardFetchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, FETCH_ID_ACTION_NAME, (ShardFetchSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_ACTION_NAME, FetchSearchResult::new);
        transportService.registerRequestHandler(QUERY_CAN_MATCH_NAME, "same", ShardSearchRequest::new, (request, channel, task) -> searchService.canMatch((ShardSearchRequest)request, new ChannelActionListener(channel, QUERY_CAN_MATCH_NAME, (ShardSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_CAN_MATCH_NAME, SearchPhaseResult.CanMatchResponse::new);
        transportService.registerRequestHandler(CREATE_READER_CONTEXT_ACTION_NAME, "same", CreateReaderContextRequest::new, (request, channel, task) -> {
            ChannelActionListener listener = new ChannelActionListener(channel, CREATE_READER_CONTEXT_ACTION_NAME, (CreateReaderContextRequest)request);
            searchService.createPitReaderContext(request.getShardId(), request.getKeepAlive(), ActionListenerHelper.wrap(r -> listener.onResponse(new CreateReaderContextResponse((ShardSearchContextId)r)), listener::onFailure));
        });
        TransportActionProxy.registerProxyAction(transportService, CREATE_READER_CONTEXT_ACTION_NAME, CreateReaderContextResponse::new);
        transportService.registerRequestHandler(UPDATE_READER_CONTEXT_ACTION_NAME, "same", UpdatePitContextRequest::new, (request, channel, task) -> {
            ChannelActionListener listener = new ChannelActionListener(channel, UPDATE_READER_CONTEXT_ACTION_NAME, (UpdatePitContextRequest)request);
            searchService.updatePitIdAndKeepAlive((UpdatePitContextRequest)request, listener);
        });
        TransportActionProxy.registerProxyAction(transportService, UPDATE_READER_CONTEXT_ACTION_NAME, UpdatePitContextResponse::new);
    }

    public TransportConnection getConnection(@Nullable String clusterAlias, DiscoveryNode node) {
        if (clusterAlias == null) {
            return this.transportService.getConnection(node);
        }
        return this.transportService.getRemoteClusterService().getConnection(node, clusterAlias);
    }

    static class SearchFreeContextRequest
    extends ScrollFreeContextRequest
    implements IndicesRequest {
        private OriginalIndices originalIndices;

        SearchFreeContextRequest(OriginalIndices originalIndices, ShardSearchContextId id) {
            super(id);
            this.originalIndices = originalIndices;
        }

        SearchFreeContextRequest(StreamInput in) throws IOException {
            super(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        }

        @Override
        public String[] indices() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indicesOptions();
        }
    }

    static class ScrollFreeContextRequest
    extends TransportRequest {
        private ShardSearchContextId contextId;

        ScrollFreeContextRequest(ShardSearchContextId contextId) {
            this.contextId = Objects.requireNonNull(contextId);
        }

        ScrollFreeContextRequest(StreamInput in) throws IOException {
            super(in);
            this.contextId = new ShardSearchContextId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.contextId.writeTo(out);
        }

        public ShardSearchContextId id() {
            return this.contextId;
        }
    }

    static class PitFreeContextsRequest
    extends TransportRequest {
        private List<PitSearchContextIdForNode> contextIds;

        PitFreeContextsRequest(List<PitSearchContextIdForNode> contextIds) {
            this.contextIds = new ArrayList<PitSearchContextIdForNode>();
            this.contextIds.addAll(contextIds);
        }

        PitFreeContextsRequest(StreamInput in) throws IOException {
            super(in);
            int size = in.readVInt();
            if (size > 0) {
                this.contextIds = new ArrayList<PitSearchContextIdForNode>();
                for (int i = 0; i < size; ++i) {
                    PitSearchContextIdForNode contextId = new PitSearchContextIdForNode(in);
                    this.contextIds.add(contextId);
                }
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.contextIds.size());
            for (PitSearchContextIdForNode contextId : this.contextIds) {
                contextId.writeTo(out);
            }
        }

        public List<PitSearchContextIdForNode> getContextIds() {
            return this.contextIds;
        }
    }

    final class ConnectionCountingHandler<Response extends TransportResponse>
    extends ActionListenerResponseHandler<Response> {
        private final Map<String, Long> clientConnections;
        private final String nodeId;

        ConnectionCountingHandler(SearchTransportService this$0, ActionListener<? super Response> listener, Writeable.Reader<Response> responseReader, Map<String, Long> clientConnections, String nodeId) {
            super(listener, responseReader);
            this.clientConnections = clientConnections;
            this.nodeId = nodeId;
            clientConnections.compute(nodeId, (id, conns) -> conns == null ? 1L : conns + 1L);
        }

        @Override
        public void handleResponse(Response response) {
            super.handleResponse(response);
            assert (this.assertNodePresent());
            this.clientConnections.computeIfPresent(this.nodeId, (id, conns) -> conns == 1L ? null : Long.valueOf(conns - 1L));
        }

        @Override
        public void handleException(TransportException e) {
            super.handleException(e);
            assert (this.assertNodePresent());
            this.clientConnections.computeIfPresent(this.nodeId, (id, conns) -> conns == 1L ? null : Long.valueOf(conns - 1L));
        }

        private boolean assertNodePresent() {
            this.clientConnections.compute(this.nodeId, (id, conns) -> {
                assert (conns != null) : "number of connections for " + id + " is null, but should be an integer";
                assert (conns >= 1L) : "number of connections for " + id + " should be >= 1 but was " + conns;
                return conns;
            });
            return true;
        }
    }

    public static class SearchFreeContextResponse
    extends TransportResponse {
        private boolean freed;

        SearchFreeContextResponse(StreamInput in) throws IOException {
            this.freed = in.readBoolean();
        }

        public SearchFreeContextResponse(boolean freed) {
            this.freed = freed;
        }

        public boolean isFreed() {
            return this.freed;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.freed);
        }
    }
}

