/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.search;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.search.DeletePitAction;
import io.skylite.core.action.search.DeletePitRequest;
import io.skylite.core.action.search.DeletePitResponse;
import io.skylite.core.action.search.PitSearchContextIdForNode;
import io.skylite.core.action.search.PitService;
import io.skylite.core.action.search.SearchContextId;
import io.skylite.core.action.search.SearchContextIdForNode;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class TransportDeletePitAction
extends HandledTransportAction<DeletePitRequest, DeletePitResponse> {
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final PitService pitService;

    @Inject
    public TransportDeletePitAction(TransportService transportService, ActionFilters actionFilters, NamedWriteableRegistry namedWriteableRegistry, PitService pitService) {
        super("indices:data/read/point_in_time/delete", transportService, actionFilters, DeletePitRequest::new);
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.pitService = pitService;
    }

    @Override
    protected void doExecute(Task task, DeletePitRequest request, ActionListener<DeletePitResponse> listener) {
        if (request.getPitIds().size() == 1 && "_all".equals(request.getPitIds().get(0))) {
            this.deleteAllPits(listener);
        } else {
            this.deletePits(listener, request);
        }
    }

    private void deletePits(ActionListener<DeletePitResponse> listener, DeletePitRequest request) {
        HashMap<String, List<PitSearchContextIdForNode>> nodeToContextsMap = new HashMap<String, List<PitSearchContextIdForNode>>();
        LinkedHashSet<String> uniquePitIds = new LinkedHashSet<String>(request.getPitIds());
        for (String pitId : uniquePitIds) {
            SearchContextId contextId = SearchContextId.decode(this.namedWriteableRegistry, pitId);
            for (SearchContextIdForNode contextIdForNode : contextId.shards().values()) {
                PitSearchContextIdForNode pitSearchContext = new PitSearchContextIdForNode(pitId, contextIdForNode);
                List contexts = nodeToContextsMap.getOrDefault(contextIdForNode.getNode(), new ArrayList());
                contexts.add(pitSearchContext);
                nodeToContextsMap.put(contextIdForNode.getNode(), contexts);
            }
        }
        this.pitService.deletePitContexts(nodeToContextsMap, listener);
    }

    private void deleteAllPits(ActionListener<DeletePitResponse> listener) {
        this.pitService.getAllPits(ActionListenerHelper.wrap(getAllPitNodesResponse -> {
            DeletePitRequest deletePitRequest = new DeletePitRequest(getAllPitNodesResponse.getPitInfos().stream().map(r -> r.getPitId()).collect(Collectors.toList()));
            this.deletePits(listener, deletePitRequest);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        @Override
        public ActionType<? extends ActionResponse> getInstance() {
            return DeletePitAction.INSTANCE;
        }

        @Override
        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportDeletePitAction.class;
        }
    }
}

