/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support;

import io.skylite.SkyliteException;
import io.skylite.common.action.ActionFuture;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.concurrent.BaseFuture;
import io.skylite.core.common.concurrent.UncategorizedExecutionException;
import io.skylite.core.common.util.FutureUtils;
import java.util.concurrent.TimeUnit;

public abstract class AdapterActionFuture<T, L>
extends BaseFuture<T>
implements ActionFuture<T>,
ActionListener<L> {
    public T actionGet() {
        try {
            return FutureUtils.get(this);
        }
        catch (SkyliteException e) {
            throw AdapterActionFuture.unwrapEsException(e);
        }
    }

    public T actionGet(String timeout) {
        return this.actionGet(TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".actionGet.timeout")));
    }

    public T actionGet(long timeoutMillis) {
        return this.actionGet(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public T actionGet(TimeValue timeout) {
        return this.actionGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    public T actionGet(long timeout, TimeUnit unit) {
        try {
            return FutureUtils.get(this, timeout, unit);
        }
        catch (SkyliteException e) {
            throw AdapterActionFuture.unwrapEsException(e);
        }
    }

    public void onResponse(L result) {
        this.set(this.convert(result));
    }

    public void onFailure(Exception e) {
        this.setException(e);
    }

    protected abstract T convert(L var1);

    private static RuntimeException unwrapEsException(SkyliteException esEx) {
        Throwable root = esEx.unwrapCause();
        if (root instanceof RuntimeException) {
            return (RuntimeException)root;
        }
        return new UncategorizedExecutionException("Failed execution", root);
    }
}

