/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support;

import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ListenableActionFuture;
import io.skylite.core.action.support.AdapterActionFuture;
import java.util.ArrayList;
import java.util.List;

public class PlainListenableActionFuture<T>
extends AdapterActionFuture<T, T>
implements ListenableActionFuture<T> {
    volatile Object listeners;
    boolean executedListeners = false;

    protected PlainListenableActionFuture() {
    }

    public static <T> PlainListenableActionFuture<T> newListenableFuture() {
        return new PlainListenableActionFuture<T>();
    }

    public void addListener(ActionListener<T> listener) {
        this.internalAddListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done(boolean success) {
        super.done(success);
        PlainListenableActionFuture plainListenableActionFuture = this;
        synchronized (plainListenableActionFuture) {
            this.executedListeners = true;
        }
        Object listeners = this.listeners;
        if (listeners != null) {
            if (listeners instanceof List) {
                List list = (List)listeners;
                for (Object listener : list) {
                    this.executeListener((ActionListener)listener);
                }
            } else {
                this.executeListener((ActionListener)listeners);
            }
        }
    }

    @Override
    protected T convert(T listenerResponse) {
        return listenerResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalAddListener(ActionListener<T> listener) {
        boolean executeImmediate = false;
        PlainListenableActionFuture plainListenableActionFuture = this;
        synchronized (plainListenableActionFuture) {
            if (this.executedListeners) {
                executeImmediate = true;
            } else {
                Object listeners = this.listeners;
                if (listeners == null) {
                    listeners = listener;
                } else if (listeners instanceof List) {
                    ((List)this.listeners).add(listener);
                } else {
                    ActionListener<T> orig = listeners;
                    listeners = new ArrayList(2);
                    ((List)listeners).add(orig);
                    ((List)listeners).add(listener);
                }
                this.listeners = listeners;
            }
        }
        if (executeImmediate) {
            this.executeListener(listener);
        }
    }

    private void executeListener(ActionListener<T> listener) {
        try {
            listener.onResponse(this.actionGet(0L));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

